"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.error = exports.createErrorFactory = exports.DataStreamMigrationError = void 0;
var _error_symbols = require("./error_symbols");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DataStreamMigrationError extends Error {
  constructor(message, symbol) {
    super(message);
    this.symbol = symbol;
  }
}
exports.DataStreamMigrationError = DataStreamMigrationError;
const createErrorFactory = symbol => message => {
  return new DataStreamMigrationError(message, symbol);
};
exports.createErrorFactory = createErrorFactory;
const error = exports.error = {
  indexNotFound: createErrorFactory(_error_symbols.IndexNotFound),
  accessForbidden: createErrorFactory(_error_symbols.AccessForbidden),
  cannotGrabMetadata: createErrorFactory(_error_symbols.MetadataCannotBeGrabbed),
  reindexTaskFailed: createErrorFactory(_error_symbols.ReindexTaskFailed),
  reindexAlreadyInProgress: createErrorFactory(_error_symbols.ReindexAlreadyInProgress),
  reindexCannotBeCancelled: createErrorFactory(_error_symbols.ReindexCannotBeCancelled),
  readonlyTaskFailed: createErrorFactory(_error_symbols.ReadonlyTaskFailed)
};