"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpgradeAssistantUIPlugin = void 0;
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class UpgradeAssistantUIPlugin {
  constructor(ctx) {
    this.ctx = ctx;
  }
  setup(coreSetup, {
    management,
    cloud,
    share,
    usageCollection
  }) {
    const {
      featureSet,
      ui: {
        enabled: isUpgradeAssistantUiEnabled
      }
    } = this.ctx.config.get();
    if (isUpgradeAssistantUiEnabled) {
      const appRegistrar = management.sections.section.stack;
      const kibanaVersion = this.ctx.env.packageInfo.version.split('.');
      const kibanaVersionMajor = Number(kibanaVersion[0]);
      const kibanaVersionInfo = {
        currentMajor: kibanaVersionMajor,
        prevMajor: kibanaVersionMajor - 1,
        nextMajor: kibanaVersionMajor + 1,
        currentMinor: Number(kibanaVersion[1]),
        currentPatch: Number(kibanaVersion[2])
      };
      const pluginName = _i18n.i18n.translate('xpack.upgradeAssistant.appTitle', {
        defaultMessage: 'Upgrade Assistant'
      });
      if (usageCollection) {
        Promise.resolve().then(() => _interopRequireWildcard(require('./application/lib/ui_metric'))).then(({
          uiMetricService
        }) => {
          uiMetricService.setup(usageCollection);
        });
      }
      appRegistrar.registerApp({
        id: 'upgrade_assistant',
        title: pluginName,
        order: 1,
        async mount(params) {
          const [coreStart, {
            data,
            reindexService
          }] = await coreSetup.getStartServices();
          const {
            chrome: {
              docTitle
            }
          } = coreStart;
          docTitle.change(pluginName);
          const appDependencies = {
            featureSet,
            kibanaVersionInfo,
            plugins: {
              cloud,
              share,
              reindexService
            },
            services: {
              core: coreStart,
              data,
              history: params.history
            }
          };
          const {
            mountManagementSection
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application/mount_management_section')));
          const unmountAppCallback = mountManagementSection(params, appDependencies);
          return () => {
            docTitle.reset();
            unmountAppCallback();
          };
        }
      });
    }
  }
  start() {}
  stop() {}
}
exports.UpgradeAssistantUIPlugin = UpgradeAssistantUIPlugin;