"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResolutionTableCell = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/upgrade_assistant/public/application/components/kibana_deprecations/resolution_table_cell.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const manualI18nTexts = {
  manualCellLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.manualCellLabel', {
    defaultMessage: 'Manual'
  }),
  manualCellTooltipLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.manualCellTooltipLabel', {
    defaultMessage: 'This issue needs to be resolved manually.'
  })
};
const automatedI18nTexts = {
  resolutionTypeCellLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.automatedCellLabel', {
    defaultMessage: 'Automated'
  }),
  resolutionProgressCellLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.automationInProgressCellLabel', {
    defaultMessage: 'Resolution in progress…'
  }),
  resolutionCompleteCellLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.automationCompleteCellLabel', {
    defaultMessage: 'Resolved'
  }),
  resolutionFailedCellLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.automationFailedCellLabel', {
    defaultMessage: 'Resolution failed'
  }),
  resolutionCellTooltipLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.automatedCellTooltipLabel', {
    defaultMessage: 'This issue can be resolved automatically.'
  })
};
const markAsResolvedI18nTexts = {
  resolutionTypeCellLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.markAsResolvedCellLabel', {
    defaultMessage: 'Mark as resolved'
  }),
  resolutionProgressCellLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.markAsResolvedInProgressCellLabel', {
    defaultMessage: 'Marking as resolved…'
  }),
  resolutionCompleteCellLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.markAsResolvedCompleteCellLabel', {
    defaultMessage: 'Marked as resolved'
  }),
  resolutionFailedCellLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.markAsResolvedFailedCellLabel', {
    defaultMessage: 'Failed to mark as resolved'
  }),
  resolutionCellTooltipLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.markAsResolvedCellTooltipLabel', {
    defaultMessage: 'This issue can be marked as resolved.'
  })
};
const ResolutionTableCell = ({
  deprecationId,
  isAutomated,
  canBeMarkedAsResolved,
  deprecationResolutionState
}) => {
  if (isAutomated || canBeMarkedAsResolved) {
    const resolutionI18nTexts = isAutomated ? automatedI18nTexts : markAsResolvedI18nTexts;
    const euiIconType = isAutomated ? 'indexSettings' : 'clickLeft';
    if ((deprecationResolutionState === null || deprecationResolutionState === void 0 ? void 0 : deprecationResolutionState.id) === deprecationId) {
      const {
        resolveDeprecationStatus
      } = deprecationResolutionState;
      switch (resolveDeprecationStatus) {
        case 'in_progress':
          return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
            gutterSize: "s",
            alignItems: "center",
            "data-test-subj": "resolutionStatusCell",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 126,
              columnNumber: 13
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 127,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
            size: "m",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 128,
              columnNumber: 17
            }
          })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 130,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            size: "s",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 131,
              columnNumber: 17
            }
          }, resolutionI18nTexts.resolutionProgressCellLabel)));
        case 'fail':
          return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
            gutterSize: "s",
            alignItems: "center",
            "data-test-subj": "resolutionStatusCell",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 137,
              columnNumber: 13
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 138,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
            type: "warningFilled",
            color: "danger",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 139,
              columnNumber: 17
            }
          })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 141,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            size: "s",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 142,
              columnNumber: 17
            }
          }, resolutionI18nTexts.resolutionFailedCellLabel)));
        case 'ok':
        default:
          return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
            gutterSize: "s",
            alignItems: "center",
            "data-test-subj": "resolutionStatusCell",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 149,
              columnNumber: 13
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 150,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
            type: "checkInCircleFilled",
            color: "success",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 151,
              columnNumber: 17
            }
          })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 153,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            size: "s",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 154,
              columnNumber: 17
            }
          }, resolutionI18nTexts.resolutionCompleteCellLabel)));
      }
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: resolutionI18nTexts.resolutionCellTooltipLabel,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      tabIndex: 0,
      gutterSize: "s",
      alignItems: "center",
      "data-test-subj": "resolutionStatusCell",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 169,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: euiIconType,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 170,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 13
      }
    }, resolutionI18nTexts.resolutionTypeCellLabel))));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: manualI18nTexts.manualCellTooltipLabel,
    "data-test-subj": "resolutionStatusCell",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    tabIndex: 0,
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 7
    }
  }, manualI18nTexts.manualCellLabel));
};
exports.ResolutionTableCell = ResolutionTableCell;