"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeprecationDetailsFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _analytics = require("@kbn/analytics");
var _eui = require("@elastic/eui");
var _ui_metric = require("../../lib/ui_metric");
var _shared = require("../shared");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/upgrade_assistant/public/application/components/kibana_deprecations/deprecation_details_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const i18nTexts = {
  closeButtonLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.flyout.closeButtonLabel', {
    defaultMessage: 'Close'
  }),
  quickResolveButtonLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.flyout.quickResolveButtonLabel', {
    defaultMessage: 'Quick resolve'
  }),
  markAsResolvedButtonLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.flyout.quickResolveButtonLabel', {
    defaultMessage: 'Mark as Resolved'
  }),
  retryQuickResolveButtonLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.flyout.retryQuickResolveButtonLabel', {
    defaultMessage: 'Try again'
  }),
  resolvedButtonLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.flyout.resolvedButtonLabel', {
    defaultMessage: 'Resolved'
  }),
  quickResolveInProgressButtonLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.flyout.quickResolveInProgressButtonLabel', {
    defaultMessage: 'Resolution in progress…'
  }),
  quickResolveCalloutTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.kibanaDeprecations.flyout.quickResolveCalloutTitle",
    defaultMessage: "Click {quickResolve} to fix this issue automatically.",
    values: {
      quickResolve: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 86,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.flyout.quickResolveText', {
        defaultMessage: 'Quick resolve'
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 5
    }
  }),
  quickResolveErrorTitle: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.flyout.quickResolveErrorTitle', {
    defaultMessage: 'Error resolving issue'
  }),
  manualFixTitle: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.flyout.manualFixTitle', {
    defaultMessage: 'How to fix'
  })
};
const {
  processingPlugins
} = (0, _eui.getDefaultEuiMarkdownPlugins)({
  processingConfig: {
    linkProps: {
      target: '_blank'
    }
  }
});
const getQuickResolveButtonLabel = (deprecationResolutionState, avilableCorrectiveActions) => {
  if ((deprecationResolutionState === null || deprecationResolutionState === void 0 ? void 0 : deprecationResolutionState.resolveDeprecationStatus) === 'in_progress') {
    return i18nTexts.quickResolveInProgressButtonLabel;
  }
  if ((deprecationResolutionState === null || deprecationResolutionState === void 0 ? void 0 : deprecationResolutionState.resolveDeprecationStatus) === 'ok') {
    return i18nTexts.resolvedButtonLabel;
  }
  if (deprecationResolutionState !== null && deprecationResolutionState !== void 0 && deprecationResolutionState.resolveDeprecationError) {
    return i18nTexts.retryQuickResolveButtonLabel;
  }
  if (avilableCorrectiveActions.api) {
    return i18nTexts.quickResolveButtonLabel;
  }
  if (avilableCorrectiveActions.markAsResolved) {
    return i18nTexts.markAsResolvedButtonLabel;
  }
};
const DeprecationDetailsFlyout = ({
  deprecation,
  closeFlyout,
  resolveDeprecation,
  deprecationResolutionState
}) => {
  const {
    documentationUrl,
    message,
    correctiveActions,
    title
  } = deprecation;
  const messages = Array.isArray(message) ? message : [message];
  const isCurrent = (deprecationResolutionState === null || deprecationResolutionState === void 0 ? void 0 : deprecationResolutionState.id) === deprecation.id;
  const avilableCorrectiveActions = {
    api: !!correctiveActions.api,
    manual: correctiveActions.manualSteps && correctiveActions.manualSteps.length > 0,
    markAsResolved: !!correctiveActions.mark_as_resolved_api
  };
  const isResolved = isCurrent && (deprecationResolutionState === null || deprecationResolutionState === void 0 ? void 0 : deprecationResolutionState.resolveDeprecationStatus) === 'ok';
  const hasResolveButton = avilableCorrectiveActions.api || avilableCorrectiveActions.markAsResolved;
  const onResolveDeprecation = (0, _react.useCallback)(() => {
    _ui_metric.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.CLICK, _ui_metric.UIM_KIBANA_QUICK_RESOLVE_CLICK);
    resolveDeprecation(deprecation);
  }, [deprecation, resolveDeprecation]);
  const {
    lineHeight: lineHeightMedium
  } = (0, _eui.useEuiFontSize)('m');
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_shared.DeprecationBadge, {
    level: deprecation.level,
    isResolved: isResolved,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    "data-test-subj": "flyoutTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "kibanaDeprecationDetailsFlyoutTitle",
    className: "eui-textBreakWord",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 11
    }
  }, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 7
    }
  }, (deprecationResolutionState === null || deprecationResolutionState === void 0 ? void 0 : deprecationResolutionState.resolveDeprecationStatus) === 'fail' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18nTexts.quickResolveErrorTitle,
    color: "danger",
    iconType: "warning",
    "data-test-subj": "quickResolveError",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 13
    }
  }, deprecationResolutionState.resolveDeprecationError), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 9
    }
  }, messages.map((currentMessage, i) => {
    if (typeof currentMessage === 'object' && currentMessage.type === 'markdown') {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, {
        key: i,
        className: "eui-textBreakWord",
        textSize: "relative",
        processingPluginList: processingPlugins,
        css: {
          marginBlockEnd: lineHeightMedium
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 203,
          columnNumber: 17
        }
      }, currentMessage.content);
    }
    const textContent = typeof currentMessage === 'string' ? currentMessage : currentMessage.content;
    return /*#__PURE__*/_react.default.createElement("p", {
      key: i,
      className: "eui-textBreakWord",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 219,
        columnNumber: 15
      }
    }, textContent);
  }), documentationUrl && /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_shared.DeprecationFlyoutLearnMoreLink, {
    documentationUrl: documentationUrl,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 9
    }
  }), !isResolved && /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "resolveSection",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 11
    }
  }, correctiveActions.api && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18nTexts.quickResolveCalloutTitle,
    color: "primary",
    iconType: "info",
    "data-test-subj": "quickResolveCallout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 17
    }
  })), correctiveActions.manualSteps.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    "data-test-subj": "manualStepsTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 19
    }
  }, i18nTexts.manualFixTitle)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 17
    }
  }, correctiveActions.manualSteps.length === 1 ? /*#__PURE__*/_react.default.createElement("p", {
    "data-test-subj": "manualStep",
    className: "eui-textBreakWord",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 21
    }
  }, correctiveActions.manualSteps[0]) : /*#__PURE__*/_react.default.createElement("ol", {
    "data-test-subj": "manualStepsList",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 21
    }
  }, correctiveActions.manualSteps.map((step, stepIndex) => /*#__PURE__*/_react.default.createElement("li", {
    "data-test-subj": "manualStepsListItem",
    key: `step-${stepIndex}`,
    className: "eui-textBreakWord",
    css: (0, _react2.css)`
                            margin-bottom: ${euiTheme.size.l};
                          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 25
    }
  }, step))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 283,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 284,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 285,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeFlyout,
    flush: "left",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 286,
      columnNumber: 13
    }
  }, i18nTexts.closeButtonLabel)), hasResolveButton && !isResolved && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    "data-test-subj": "resolveButton",
    onClick: onResolveDeprecation,
    isLoading: Boolean((deprecationResolutionState === null || deprecationResolutionState === void 0 ? void 0 : deprecationResolutionState.resolveDeprecationStatus) === 'in_progress'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 15
    }
  }, getQuickResolveButtonLabel(deprecationResolutionState, avilableCorrectiveActions))))));
};
exports.DeprecationDetailsFlyout = DeprecationDetailsFlyout;