"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FixSnapshotsFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _analytics = require("@kbn/analytics");
var _eui = require("@elastic/eui");
var _ui_metric = require("../../../../lib/ui_metric");
var _app_context = require("../../../../app_context");
var _shared = require("../../../shared");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/upgrade_assistant/public/application/components/es_deprecations/deprecation_types/ml_snapshots/flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const i18nTexts = {
  upgradeButtonLabel: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.mlSnapshots.flyout.upgradeButtonLabel', {
    defaultMessage: 'Upgrade'
  }),
  upgradingButtonLabel: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.mlSnapshots.flyout.upgradingButtonLabel', {
    defaultMessage: 'Upgrading…'
  }),
  retryUpgradeButtonLabel: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.mlSnapshots.flyout.retryUpgradeButtonLabel', {
    defaultMessage: 'Retry upgrade'
  }),
  closeButtonLabel: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.mlSnapshots.flyout.closeButtonLabel', {
    defaultMessage: 'Close'
  }),
  deleteButtonLabel: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.mlSnapshots.flyout.deleteButtonLabel', {
    defaultMessage: 'Delete'
  }),
  deletingButtonLabel: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.mlSnapshots.flyout.deletingButtonLabel', {
    defaultMessage: 'Deleting…'
  }),
  retryDeleteButtonLabel: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.mlSnapshots.flyout.retryDeleteButtonLabel', {
    defaultMessage: 'Retry delete'
  }),
  flyoutTitle: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.mlSnapshots.flyout.title', {
    defaultMessage: 'Upgrade or delete model snapshot'
  }),
  deleteSnapshotErrorTitle: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.mlSnapshots.flyout.deleteSnapshotErrorTitle', {
    defaultMessage: 'Error deleting snapshot'
  }),
  upgradeSnapshotErrorTitle: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.mlSnapshots.flyout.upgradeSnapshotErrorTitle', {
    defaultMessage: 'Error upgrading snapshot'
  }),
  upgradeModeEnabledErrorTitle: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.mlSnapshots.upgradeModeEnabledErrorTitle', {
    defaultMessage: 'Machine Learning upgrade mode is enabled'
  }),
  upgradeModeEnabledErrorDescription: docsLink => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.esDeprecations.mlSnapshots.upgradeModeEnabledErrorDescription",
    defaultMessage: "No actions can be taken on Machine Learning snapshots while upgrade mode is enabled. {docsLink}.",
    values: {
      docsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docsLink,
        target: "_blank",
        "data-test-subj": "setUpgradeModeDocsLink",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 114,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.esDeprecations.mlSnapshots.upgradeModeEnabledDocsLink",
        defaultMessage: "Learn more",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 115,
          columnNumber: 13
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 5
    }
  })
};
const getDeleteButtonLabel = snapshotState => {
  if (snapshotState.action === 'delete') {
    if (snapshotState.error) {
      return i18nTexts.retryDeleteButtonLabel;
    }
    switch (snapshotState.status) {
      case 'in_progress':
        return i18nTexts.deletingButtonLabel;
      case 'idle':
      default:
        return i18nTexts.deleteButtonLabel;
    }
  }
  return i18nTexts.deleteButtonLabel;
};
const getUpgradeButtonLabel = snapshotState => {
  if (snapshotState.action === 'upgrade') {
    if (snapshotState.error) {
      return i18nTexts.retryUpgradeButtonLabel;
    }
    switch (snapshotState.status) {
      case 'in_progress':
        return i18nTexts.upgradingButtonLabel;
      case 'idle':
      default:
        return i18nTexts.upgradeButtonLabel;
    }
  }
  return i18nTexts.upgradeButtonLabel;
};
const FixSnapshotsFlyout = ({
  deprecation,
  closeFlyout,
  snapshotState,
  upgradeSnapshot,
  deleteSnapshot,
  mlUpgradeModeEnabled
}) => {
  const {
    services: {
      core: {
        docLinks
      }
    }
  } = (0, _app_context.useAppContext)();
  const isResolved = snapshotState.status === 'complete';
  const onUpgradeSnapshot = () => {
    _ui_metric.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.CLICK, _ui_metric.UIM_ML_SNAPSHOT_UPGRADE_CLICK);
    upgradeSnapshot();
    closeFlyout();
  };
  const onDeleteSnapshot = () => {
    _ui_metric.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.CLICK, _ui_metric.UIM_ML_SNAPSHOT_DELETE_CLICK);
    deleteSnapshot();
    closeFlyout();
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_shared.DeprecationBadge, {
    level: deprecation.level,
    isResolved: isResolved,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    "data-test-subj": "flyoutTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "mlSnapshotDetailsFlyoutTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 11
    }
  }, i18nTexts.flyoutTitle))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 7
    }
  }, snapshotState.error && !isResolved && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: snapshotState.action === 'delete' ? i18nTexts.deleteSnapshotErrorTitle : i18nTexts.upgradeSnapshotErrorTitle,
    color: "danger",
    iconType: "warning",
    "data-test-subj": "resolveSnapshotError",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 13
    }
  }, snapshotState.error.message), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 13
    }
  })), mlUpgradeModeEnabled && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18nTexts.upgradeModeEnabledErrorTitle,
    color: "warning",
    iconType: "warning",
    "data-test-subj": "mlUpgradeModeEnabledError",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 15
    }
  }, i18nTexts.upgradeModeEnabledErrorDescription(docLinks.links.ml.setUpgradeMode))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 11
    }
  }, deprecation.details), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_shared.DeprecationFlyoutLearnMoreLink, {
    documentationUrl: deprecation.url,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeFlyout,
    flush: "left",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 13
    }
  }, i18nTexts.closeButtonLabel)), !isResolved && !mlUpgradeModeEnabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "deleteSnapshotButton",
    color: "danger",
    onClick: onDeleteSnapshot,
    isLoading: snapshotState.action === 'delete' && snapshotState.status === 'in_progress',
    isDisabled: snapshotState.status === 'in_progress',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 19
    }
  }, getDeleteButtonLabel(snapshotState))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: onUpgradeSnapshot,
    isLoading: snapshotState.action === 'upgrade' && snapshotState.status === 'in_progress',
    isDisabled: snapshotState.status === 'in_progress',
    "data-test-subj": "upgradeSnapshotButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 19
    }
  }, getUpgradeButtonLabel(snapshotState))))))));
};
exports.FixSnapshotsFlyout = FixSnapshotsFlyout;