"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReindexResolutionCell = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _upgradeAssistantPkgCommon = require("@kbn/upgrade-assistant-pkg-common");
var _utils = require("../../../../lib/utils");
var _types = require("../../../types");
var _context = require("./context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/upgrade_assistant/public/application/components/es_deprecations/deprecation_types/indices/resolution_table_cell.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const recommendedReadOnlyText = _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indices.recommendedActionReadonlyText', {
  defaultMessage: 'Recommended: set to read-only'
});
const recommendedReindexText = _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indices.recommendedActionReindexText', {
  defaultMessage: 'Recommended: reindex'
});
const i18nTexts = {
  reindexLoadingStatusText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indices.reindexLoadingStatusText', {
    defaultMessage: 'Loading status…'
  }),
  reindexInProgressText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indices.reindexInProgressText', {
    defaultMessage: 'Reindexing in progress…'
  }),
  reindexCompleteText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indices.reindexCompleteText', {
    defaultMessage: 'Reindex complete'
  }),
  reindexFailedText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indices.reindexFailedText', {
    defaultMessage: 'Reindex failed'
  }),
  reindexFetchFailedText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indices.reindexFetchFailedText', {
    defaultMessage: 'Reindex status not available'
  }),
  reindexPausedText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indices.reindexPausedText', {
    defaultMessage: 'Reindex paused'
  }),
  updateCompleteText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indices.updateCompleteText', {
    defaultMessage: 'Update complete'
  }),
  updateInProgressText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indices.updateInProgressText', {
    defaultMessage: 'Update in progress…'
  }),
  unfreezeCompleteText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indices.unfreezeCompleteText', {
    defaultMessage: 'Index is unfrozen'
  }),
  unfreezeInProgressText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indices.unfreezeInProgressText', {
    defaultMessage: 'Unfreezing index…'
  }),
  readOnlyCompleteText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indices.readOnlyCompleteText', {
    defaultMessage: 'Index is set to read-only'
  }),
  readOnlyInProgressText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indices.readOnlyInProgressText', {
    defaultMessage: 'Setting index to read-only…'
  }),
  recommendedActionTexts: {
    isLargeIndex: {
      text: recommendedReadOnlyText,
      tooltipText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indices.recommendedActionReadonlyReasonIsLargeIndex', {
        defaultMessage: 'This index is larger than 1GB. Reindexing large indices can take a long time. If you no longer need to update documents in this index (or add new ones), you might want to set it to read-only.'
      })
    },
    isFollowerIndex: {
      text: recommendedReadOnlyText,
      tooltipText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indices.recommendedActionReadonlyReasonIsFollowerIndex', {
        defaultMessage: 'This index is a cross-cluster replication follower index, which should not be reindexed. You can set it to read-only or terminate the replication and convert it to a standard index.'
      })
    },
    readonly: {
      text: recommendedReadOnlyText,
      tooltipText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indices.recommendedActionReadonlyReasonReadonly', {
        defaultMessage: 'Old indices can maintain compatibility with the next major version if they are set to read-only mode. If you no longer need to update documents in this index (or add new ones), you might want to set it to a read-only index.'
      })
    },
    isReadonly: {
      text: recommendedReindexText,
      tooltipText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indices.recommendedActionReindexReasonReadonly', {
        defaultMessage: 'This index is read-only. You can still reindex it.'
      })
    },
    reindex: {
      text: recommendedReindexText,
      tooltipText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indices.recommendedActionReindexTooltipText', {
        defaultMessage: 'The reindex operation transforms an index into a new, compatible one. It will copy all of the existing documents into a new index and remove the old one. Depending on size and resources, reindexing may take extended time and your data will be in a read-only state until the job has completed.'
      })
    },
    unfreeze: {
      text: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indices.recommendedOptionUnfreezeText', {
        defaultMessage: 'Recommended: unfreeze'
      }),
      tooltipText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indices.recommendedOptionReadonlyReasonFreeze', {
        defaultMessage: 'To ensure compatibility with the next major version, unfreeze is recommended. It will also be set to read-only.'
      })
    },
    terminateReplication: {
      text: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indices.recommendedOptionTerminateReplicationText', {
        defaultMessage: 'Resolve manually'
      }),
      tooltipText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indices.recommendedOptionTerminateReplicationReason', {
        defaultMessage: 'This index is a follower index that has already been set to read-only. You can terminate the replication and convert it to a standard index.'
      })
    }
  }
};
const ReindexResolutionCell = ({
  deprecation
}) => {
  var _deprecation$correcti, _deprecation$correcti2;
  const {
    reindexState,
    updateIndexState
  } = (0, _context.useIndexContext)();
  const {
    correctiveAction
  } = deprecation;
  const hasExistingAliases = reindexState.meta.aliases.length > 0;
  const getRecommendedActionForUnfreezeAction = () => {
    // Unfreeze is always the Recommended action for frozen index
    return 'unfreeze';
  };
  const getRecommendedActionForReindexingAction = () => {
    const {
      meta
    } = reindexState;
    const {
      isReadonly,
      isFollowerIndex
    } = meta;
    const {
      excludedActions = [],
      indexSizeInBytes = 0
    } = deprecation.correctiveAction || {};

    // Determine if the index is larger than 1GB
    const isLargeIndex = indexSizeInBytes > 1073741824;
    const readOnlyExcluded = excludedActions.includes('readOnly');
    const reindexExcluded = excludedActions.includes('reindex');

    // Follower index can only be reindexed
    if (isFollowerIndex && !readOnlyExcluded && !isReadonly) {
      return 'isFollowerIndex';
    }
    // Large index is always recommended to be set to read-only unless excluded or already read-only
    if (isLargeIndex && !readOnlyExcluded && !isReadonly) {
      return 'isLargeIndex';
    }
    // Follower index but already read-only, manual fix
    if (isFollowerIndex && isReadonly) {
      return 'terminateReplication';
    }
    // If it's already read-only and not excluded from reindexing, recommend reindexing unless it's a follower index
    if (isReadonly && !reindexExcluded && !isFollowerIndex) {
      return 'isReadonly';
    }
    // If reindexing is excluded and read-only is not, recommend setting it to read-only
    if (reindexExcluded && !readOnlyExcluded && !isReadonly) {
      return 'readonly';
    }
    // Default: reindex
    return 'reindex';
  };
  const recommendedAction = (correctiveAction === null || correctiveAction === void 0 ? void 0 : correctiveAction.type) === 'unfreeze' ? getRecommendedActionForUnfreezeAction() : getRecommendedActionForReindexingAction();
  const updateAction = ((_deprecation$correcti = deprecation.correctiveAction) === null || _deprecation$correcti === void 0 ? void 0 : _deprecation$correcti.type) === 'unfreeze' ? 'unfreeze' : ((_deprecation$correcti2 = deprecation.correctiveAction) === null || _deprecation$correcti2 === void 0 ? void 0 : _deprecation$correcti2.type) === 'reindex' ? 'readOnly' : 'update';
  if (reindexState.loadingState === _types.LoadingState.Loading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 266,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 267,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 268,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 270,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 271,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("em", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 272,
        columnNumber: 13
      }
    }, i18nTexts.reindexLoadingStatusText))));
  }
  switch (reindexState.status) {
    case _upgradeAssistantPkgCommon.ReindexStatus.inProgress:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        alignItems: "center",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 282,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 283,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 284,
          columnNumber: 13
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 286,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 287,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("em", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 288,
          columnNumber: 15
        }
      }, i18nTexts.reindexInProgressText, ' ', (0, _utils.getReindexProgressLabel)(reindexState.reindexTaskPercComplete, reindexState.lastCompletedStep, hasExistingAliases)))));
    case _upgradeAssistantPkgCommon.ReindexStatus.completed:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        alignItems: "center",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 302,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 303,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "checkInCircleFilled",
        color: "success",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 304,
          columnNumber: 13
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 306,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 307,
          columnNumber: 13
        }
      }, i18nTexts.reindexCompleteText)));
    case _upgradeAssistantPkgCommon.ReindexStatus.failed:
      if (updateIndexState.status !== 'complete') {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "s",
          alignItems: "center",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 314,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 315,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "warningFilled",
          color: "danger",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 316,
            columnNumber: 15
          }
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 318,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 319,
            columnNumber: 15
          }
        }, i18nTexts.reindexFailedText)));
      }
      break;
    case _upgradeAssistantPkgCommon.ReindexStatus.fetchFailed:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        alignItems: "center",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 327,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 328,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "warningFilled",
        color: "danger",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 329,
          columnNumber: 13
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 331,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 332,
          columnNumber: 13
        }
      }, i18nTexts.reindexFetchFailedText)));
    case _upgradeAssistantPkgCommon.ReindexStatus.paused:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        alignItems: "center",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 338,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 339,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "warningFilled",
        color: "danger",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 340,
          columnNumber: 13
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 342,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 343,
          columnNumber: 13
        }
      }, i18nTexts.reindexPausedText)));
  }
  switch (updateIndexState.status) {
    case 'inProgress':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        alignItems: "center",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 352,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 353,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 354,
          columnNumber: 13
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 356,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 357,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("em", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 358,
          columnNumber: 15
        }
      }, i18nTexts[`${updateAction}InProgressText`]))));
    case 'complete':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        alignItems: "center",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 365,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 366,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "checkInCircleFilled",
        color: "success",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 367,
          columnNumber: 13
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 369,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 370,
          columnNumber: 13
        }
      }, i18nTexts[`${updateAction}CompleteText`])));
  }
  if (recommendedAction) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 378,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("em", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 379,
        columnNumber: 9
      }
    }, i18nTexts.recommendedActionTexts[recommendedAction].text, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      position: "top",
      content: i18nTexts.recommendedActionTexts[recommendedAction].tooltipText,
      type: "info",
      "aria-label": i18nTexts.recommendedActionTexts[recommendedAction].tooltipText,
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 381,
        columnNumber: 11
      }
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
};
exports.ReindexResolutionCell = ReindexResolutionCell;