"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReindexProgress = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("@kbn/reindex-service-plugin/common");
var _upgradeAssistantPkgCommon = require("@kbn/upgrade-assistant-pkg-common");
var _types = require("../../../../../../types");
var _step_progress = require("../../../../../common/step_progress");
var _utils = require("../../../../../../../lib/utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/upgrade_assistant/public/application/components/es_deprecations/deprecation_types/indices/flyout/steps/reindex/progress.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ErrorCallout = ({
  errorMessage
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  color: "danger",
  title: "There was an error",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 33,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 34,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement("p", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 35,
    columnNumber: 7
  }
}, errorMessage)));
const PausedCallout = () => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  color: "warning",
  title: "This step was paused due to a Kibana restart. Click 'Resume' below to continue.",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 41,
    columnNumber: 3
  }
});
const ReindexingDocumentsStepTitle = ({
  reindexState: {
    lastCompletedStep,
    status,
    cancelLoadingState
  },
  cancelReindex
}) => {
  if (status === _upgradeAssistantPkgCommon.ReindexStatus.cancelled) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.upgradeAssistant.esDeprecations.indices.indexFlyout.reindexStep.reindexingChecklist.cancelledTitle",
      defaultMessage: "Reindexing cancelled.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 9
      }
    }));
  }

  // step is in progress after the new index is created and while it's not completed yet
  const stepInProgress = status === _upgradeAssistantPkgCommon.ReindexStatus.inProgress && (lastCompletedStep === _common.ReindexStep.newIndexCreated || lastCompletedStep === _common.ReindexStep.reindexStarted);
  // but the reindex can only be cancelled after it has started
  const showCancelLink = status === _upgradeAssistantPkgCommon.ReindexStatus.inProgress && lastCompletedStep === _common.ReindexStep.reindexStarted;
  let cancelText;
  switch (cancelLoadingState) {
    case _types.CancelLoadingState.Requested:
    case _types.CancelLoadingState.Loading:
      cancelText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.esDeprecations.indices.indexFlyout.reindexStep.reindexingChecklist.cancelButton.cancellingLabel",
        defaultMessage: "Cancelling\u2026",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 76,
          columnNumber: 9
        }
      });
      break;
    case _types.CancelLoadingState.Success:
      cancelText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.esDeprecations.indices.indexFlyout.reindexStep.reindexingChecklist.cancelButton.cancelledLabel",
        defaultMessage: "Cancelled",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 84,
          columnNumber: 9
        }
      });
      break;
    case _types.CancelLoadingState.Error:
      cancelText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.esDeprecations.indices.indexFlyout.reindexStep.reindexingChecklist.cancelButton.errorLabel",
        defaultMessage: "Could not cancel",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 92,
          columnNumber: 9
        }
      });
      break;
    default:
      cancelText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.esDeprecations.indices.indexFlyout.reindexStep.reindexingChecklist.cancelButton.cancelLabel",
        defaultMessage: "Cancel",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 100,
          columnNumber: 9
        }
      });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    component: "span",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 7
    }
  }, stepInProgress ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.esDeprecations.indices.indexFlyout.reindexStep.reindexingChecklist.inProgress.reindexingDocumentsStepTitle",
    defaultMessage: "Reindexing documents.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.esDeprecations.indices.indexFlyout.reindexStep.reindexingChecklist.reindexingDocumentsStepTitle",
    defaultMessage: "Reindex documents.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 11
    }
  })), showCancelLink && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "cancelReindexingDocumentsButton",
    onClick: cancelReindex,
    disabled: cancelLoadingState !== undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 11
    }
  }, cancelText)));
};
const orderedSteps = Object.values(_common.ReindexStep).sort();
const getStepTitle = (step, meta, inProgress) => {
  if (step === _common.ReindexStep.readonly) {
    return inProgress ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.upgradeAssistant.esDeprecations.indices.indexFlyout.reindexStep.reindexingChecklist.inProgress.readonlyStepTitle",
      defaultMessage: "Setting {indexName} index to read-only.",
      values: {
        indexName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 150,
            columnNumber: 22
          }
        }, meta.indexName)
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 7
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.upgradeAssistant.esDeprecations.indices.indexFlyout.reindexStep.reindexingChecklist.readonlyStepTitle",
      defaultMessage: "Set {indexName} index to read-only.",
      values: {
        indexName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 158,
            columnNumber: 22
          }
        }, meta.indexName)
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 7
      }
    });
  }
  if (step === _common.ReindexStep.newIndexCreated) {
    return inProgress ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.upgradeAssistant.esDeprecations.indices.indexFlyout.reindexStep.reindexingChecklist.inProgress.createIndexStepTitle",
      defaultMessage: "Creating {reindexName} index.",
      values: {
        reindexName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 170,
            columnNumber: 24
          }
        }, meta.reindexName)
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 166,
        columnNumber: 7
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.upgradeAssistant.esDeprecations.indices.indexFlyout.reindexStep.reindexingChecklist.createIndexStepTitle",
      defaultMessage: "Create {reindexName} index.",
      values: {
        reindexName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 178,
            columnNumber: 24
          }
        }, meta.reindexName)
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 174,
        columnNumber: 7
      }
    });
  }
  if (step === _common.ReindexStep.indexSettingsRestored) {
    return inProgress ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.upgradeAssistant.esDeprecations.indices.indexFlyout.reindexStep.reindexingChecklist.inProgress.indexSettingsRestoredStepTitle",
      defaultMessage: "Copying original index settings from {indexName} to {reindexName}.",
      values: {
        indexName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 190,
            columnNumber: 22
          }
        }, meta.indexName),
        reindexName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 191,
            columnNumber: 24
          }
        }, meta.reindexName)
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 186,
        columnNumber: 7
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.upgradeAssistant.esDeprecations.indices.indexFlyout.reindexStep.reindexingChecklist.indexSettingsRestoredStepTitle",
      defaultMessage: "Copy original index settings from {indexName} to {reindexName}.",
      values: {
        indexName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 199,
            columnNumber: 22
          }
        }, meta.indexName),
        reindexName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 200,
            columnNumber: 24
          }
        }, meta.reindexName)
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 195,
        columnNumber: 7
      }
    });
  }
  if (step === _common.ReindexStep.aliasCreated) {
    return inProgress ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.upgradeAssistant.esDeprecations.indices.indexFlyout.reindexStep.reindexingChecklist.inProgress.aliasCreatedStepTitle",
      defaultMessage: "Creating {indexName} alias for {reindexName} index.",
      values: {
        indexName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 212,
            columnNumber: 22
          }
        }, meta.indexName),
        reindexName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 213,
            columnNumber: 24
          }
        }, meta.reindexName)
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 208,
        columnNumber: 7
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.upgradeAssistant.esDeprecations.indices.indexFlyout.reindexStep.reindexingChecklist.aliasCreatedStepTitle",
      defaultMessage: "Create {indexName} alias for {reindexName} index.",
      values: {
        indexName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 221,
            columnNumber: 22
          }
        }, meta.indexName),
        reindexName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 222,
            columnNumber: 24
          }
        }, meta.reindexName)
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 217,
        columnNumber: 7
      }
    });
  }
  if (step === _common.ReindexStep.originalIndexDeleted) {
    return inProgress ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.upgradeAssistant.esDeprecations.indices.indexFlyout.reindexStep.reindexingChecklist.inProgress.originalIndexDeletedStepTitle",
      defaultMessage: "Deleting original {indexName} index.",
      values: {
        indexName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 234,
            columnNumber: 22
          }
        }, meta.indexName)
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 230,
        columnNumber: 7
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.upgradeAssistant.esDeprecations.indices.indexFlyout.reindexStep.reindexingChecklist.originalIndexDeletedStepTitle",
      defaultMessage: "Delete original {indexName} index.",
      values: {
        indexName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 242,
            columnNumber: 22
          }
        }, meta.indexName)
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 238,
        columnNumber: 7
      }
    });
  }
  if (step === _common.ReindexStep.existingAliasesUpdated) {
    return inProgress ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.upgradeAssistant.esDeprecations.indices.indexFlyout.reindexStep.reindexingChecklist.inProgress.aliasesUpdatedStepTitle",
      defaultMessage: "Updating {existingAliases} aliases to point to {reindexName} index.",
      values: {
        existingAliases: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 254,
            columnNumber: 28
          }
        }, `[${meta.aliases.join(',')}]`),
        reindexName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 255,
            columnNumber: 24
          }
        }, meta.reindexName)
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 250,
        columnNumber: 7
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.upgradeAssistant.esDeprecations.indices.indexFlyout.reindexStep.reindexingChecklist.aliasesUpdatedStepTitle",
      defaultMessage: "Update {existingAliases} aliases to point to {reindexName} index.",
      values: {
        existingAliases: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 263,
            columnNumber: 28
          }
        }, `[${meta.aliases.join(',')}]`),
        reindexName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 264,
            columnNumber: 24
          }
        }, meta.reindexName)
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 259,
        columnNumber: 7
      }
    });
  }
};
/**
 * Displays a list of steps in the reindex operation, the current status, a progress bar,
 * and any error messages that are encountered.
 */
const ReindexProgress = props => {
  const {
    errorMessage,
    lastCompletedStep = -1,
    status,
    reindexTaskPercComplete,
    meta
  } = props.reindexState;
  const getProgressStep = thisStep => {
    const previousStep = orderedSteps[orderedSteps.indexOf(thisStep) - 1];
    if (status === _upgradeAssistantPkgCommon.ReindexStatus.failed && lastCompletedStep === previousStep) {
      return {
        title: getStepTitle(thisStep, meta),
        status: 'failed',
        children: /*#__PURE__*/_react.default.createElement(ErrorCallout, {
          errorMessage,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 296,
            columnNumber: 19
          }
        })
      };
    } else if (status === _upgradeAssistantPkgCommon.ReindexStatus.paused && lastCompletedStep === previousStep) {
      return {
        title: getStepTitle(thisStep, meta),
        status: 'paused',
        children: /*#__PURE__*/_react.default.createElement(PausedCallout, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 302,
            columnNumber: 19
          }
        })
      };
    } else if (status === _upgradeAssistantPkgCommon.ReindexStatus.cancelled && lastCompletedStep === previousStep) {
      return {
        title: getStepTitle(thisStep, meta),
        status: 'cancelled'
      };
    } else if (status === undefined || lastCompletedStep < previousStep) {
      return {
        title: getStepTitle(thisStep, meta),
        status: 'incomplete'
      };
    } else if (lastCompletedStep === previousStep) {
      return {
        title: getStepTitle(thisStep, meta, true),
        status: 'inProgress'
      };
    } else {
      return {
        title: getStepTitle(thisStep, meta),
        status: 'complete'
      };
    }
  };

  // The reindexing step is special because it generally lasts longer and can be cancelled mid-flight
  const reindexingDocsStep = {
    title: /*#__PURE__*/_react.default.createElement(ReindexingDocumentsStepTitle, (0, _extends2.default)({}, props, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 329,
        columnNumber: 12
      }
    }))
  };
  if (status === _upgradeAssistantPkgCommon.ReindexStatus.failed && (lastCompletedStep === _common.ReindexStep.newIndexCreated || lastCompletedStep === _common.ReindexStep.reindexStarted)) {
    reindexingDocsStep.status = 'failed';
    reindexingDocsStep.children = /*#__PURE__*/_react.default.createElement(ErrorCallout, {
      errorMessage,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 338,
        columnNumber: 35
      }
    });
  } else if (status === _upgradeAssistantPkgCommon.ReindexStatus.paused && (lastCompletedStep === _common.ReindexStep.newIndexCreated || lastCompletedStep === _common.ReindexStep.reindexStarted)) {
    reindexingDocsStep.status = 'paused';
    reindexingDocsStep.children = /*#__PURE__*/_react.default.createElement(PausedCallout, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 345,
        columnNumber: 35
      }
    });
  } else if (status === _upgradeAssistantPkgCommon.ReindexStatus.cancelled && (lastCompletedStep === _common.ReindexStep.newIndexCreated || lastCompletedStep === _common.ReindexStep.reindexStarted)) {
    reindexingDocsStep.status = 'cancelled';
  } else if (status === undefined || lastCompletedStep < _common.ReindexStep.newIndexCreated) {
    reindexingDocsStep.status = 'incomplete';
  } else if (lastCompletedStep === _common.ReindexStep.newIndexCreated || lastCompletedStep === _common.ReindexStep.reindexStarted) {
    reindexingDocsStep.status = 'inProgress';
  } else {
    reindexingDocsStep.status = 'complete';
  }
  const steps = [getProgressStep(_common.ReindexStep.readonly), getProgressStep(_common.ReindexStep.newIndexCreated), reindexingDocsStep, getProgressStep(_common.ReindexStep.indexSettingsRestored), getProgressStep(_common.ReindexStep.aliasCreated), getProgressStep(_common.ReindexStep.originalIndexDeleted)];
  const hasExistingAliases = meta.aliases.length > 0;
  if (hasExistingAliases) {
    steps.push(getProgressStep(_common.ReindexStep.existingAliasesUpdated));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    "data-test-subj": "reindexChecklistTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 380,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 381,
      columnNumber: 9
    }
  }, status === _upgradeAssistantPkgCommon.ReindexStatus.inProgress ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.esDeprecations.indices.indexFlyout.reindexStep.reindexingInProgressTitle",
    defaultMessage: "Reindexing in progress\u2026 {percents}",
    values: {
      percents: (0, _utils.getReindexProgressLabel)(reindexTaskPercComplete,
      // @ts-expect-error upgrade typescript v5.1.6
      lastCompletedStep, hasExistingAliases)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 383,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.esDeprecations.indices.indexFlyout.reindexStep.reindexingChecklistTitle",
    defaultMessage: "Reindexing process",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 396,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_step_progress.StepProgress, {
    steps: steps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 403,
      columnNumber: 7
    }
  }));
};
exports.ReindexProgress = ReindexProgress;