"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataStreamTableRow = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _analytics = require("@kbn/analytics");
var _types = require("../../../../../../common/types");
var _shared_imports = require("../../../../../shared_imports");
var _app_context = require("../../../../app_context");
var _ui_metric = require("../../../../lib/ui_metric");
var _es_deprecations_table_cells = require("../../es_deprecations_table_cells");
var _resolution_table_cell = require("./resolution_table_cell");
var _flyout = require("./flyout");
var _context = require("./context");
var _actions_table_cell = require("./actions_table_cell");
var _modal_container = require("./flyout/modal_container");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/upgrade_assistant/public/application/components/es_deprecations/deprecation_types/data_streams/table_row.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  useGlobalFlyout
} = _shared_imports.GlobalFlyout;
const DataStreamTableRowCells = ({
  rowFieldNames,
  deprecation,
  index
}) => {
  const [showFlyout, setShowFlyout] = (0, _react.useState)(false);
  const [showModal, setShowModal] = (0, _react.useState)(false);
  const dataStreamContext = (0, _context.useDataStreamMigrationContext)();
  const {
    addContent: addContentToGlobalFlyout,
    removeContent: removeContentFromGlobalFlyout
  } = useGlobalFlyout();
  const {
    initMigration,
    migrationState
  } = dataStreamContext;
  const closeFlyout = (0, _react.useCallback)(async () => {
    removeContentFromGlobalFlyout('dataStreamReindexFlyout');
    setShowFlyout(false);
    _ui_metric.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.CLICK, _ui_metric.UIM_DATA_STREAM_REINDEX_CLOSE_FLYOUT_CLICK);
  }, [removeContentFromGlobalFlyout]);
  (0, _react.useEffect)(() => {
    if (showFlyout) {
      addContentToGlobalFlyout({
        id: 'dataStreamReindexFlyout',
        Component: _flyout.DataStreamReindexFlyout,
        props: {
          ...dataStreamContext,
          deprecation,
          closeFlyout
        },
        flyoutProps: {
          onClose: closeFlyout,
          className: 'eui-textBreakWord',
          'data-test-subj': 'reindexDataStreamDetails',
          'aria-labelledby': 'reindexDataStreamDetailsFlyoutTitle'
        }
      });
    }
  }, [addContentToGlobalFlyout, deprecation, dataStreamContext, showFlyout, closeFlyout]);
  const closeModal = (0, _react.useCallback)(() => {
    setShowModal(false);
    _ui_metric.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.CLICK, _ui_metric.UIM_DATA_STREAM_REINDEX_CLOSE_MODAL_CLICK);
  }, []);
  (0, _react.useEffect)(() => {
    if (showFlyout) {
      _ui_metric.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.CLICK, _ui_metric.UIM_DATA_STREAM_REINDEX_OPEN_FLYOUT_CLICK);
    }
  }, [showFlyout]);
  (0, _react.useEffect)(() => {
    if (showModal) {
      _ui_metric.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.CLICK, _ui_metric.UIM_DATA_STREAM_REINDEX_OPEN_MODAL_CLICK);
    }
  }, [showModal]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showModal && /*#__PURE__*/_react.default.createElement(_modal_container.DataStreamReadonlyModal, (0, _extends2.default)({
    closeModal: closeModal,
    deprecation: deprecation
  }, dataStreamContext, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
    "data-test-subj": "deprecationTableRow",
    key: `deprecation-row-${index}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  }, rowFieldNames.map(field => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
      key: field,
      truncateText: false,
      "data-test-subj": `dataStreamReindexTableCell-${field}`,
      align: field === 'actions' ? 'right' : 'left',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_es_deprecations_table_cells.EsDeprecationsTableCells, {
      fieldName: field,
      deprecation: deprecation,
      resolutionTableCell: /*#__PURE__*/_react.default.createElement(_resolution_table_cell.DataStreamReindexResolutionCell, {
        correctiveAction: deprecation.correctiveAction,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 115,
          columnNumber: 19
        }
      }),
      actionsTableCell: /*#__PURE__*/_react.default.createElement(_actions_table_cell.DataStreamReindexActionsCell, {
        correctiveAction: deprecation.correctiveAction,
        openFlyout: () => {
          setShowFlyout(true);
          if (migrationState.status === _types.DataStreamMigrationStatus.notStarted) {
            initMigration('reindex');
          }
        },
        openModal: () => {
          setShowModal(true);
          if (migrationState.status === _types.DataStreamMigrationStatus.notStarted) {
            initMigration('readonly');
          }
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 120,
          columnNumber: 19
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 15
      }
    }));
  })));
};
const DataStreamTableRow = props => {
  const {
    services: {
      api
    }
  } = (0, _app_context.useAppContext)();
  return /*#__PURE__*/_react.default.createElement(_context.DataStreamMigrationStatusProvider, {
    dataStreamName: props.deprecation.index,
    api: api,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(DataStreamTableRowCells, (0, _extends2.default)({}, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 7
    }
  })));
};
exports.DataStreamTableRow = DataStreamTableRow;