"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AffectExistingSetupsWarningCheckbox = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _warning_step_checkbox = require("./warning_step_checkbox");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/upgrade_assistant/public/application/components/es_deprecations/deprecation_types/data_streams/flyout/steps/confirm/warnings/existing_setups.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AffectExistingSetupsWarningCheckbox = ({
  isChecked,
  onChange,
  id,
  meta
}) => {
  return /*#__PURE__*/_react.default.createElement(_warning_step_checkbox.WarningCheckbox, {
    isChecked: isChecked,
    onChange: onChange,
    warningId: id,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      tagName: "b",
      id: "xpack.upgradeAssistant.dataStream.migration.flyout.warningsStep.affectExistingSetupsWarningLabel",
      defaultMessage: "Set to read-only all incompatible data for this data stream",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 25,
        columnNumber: 9
      }
    }),
    dataStreamName: meta === null || meta === void 0 ? void 0 : meta.dataStreamName,
    description: meta && typeof meta.indicesRequiringUpgradeCount === 'number' && meta.indicesRequiringUpgradeCount > 0 && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      tagName: "p",
      id: "xpack.upgradeAssistant.dataStream.modal.confirmStep.readonly.acceptChangesTitle",
      defaultMessage: "{count, plural, =1 {# backing index} other {# backing indices}}, including current write index, will be set to read-only.",
      values: {
        count: meta.indicesRequiringUpgradeCount
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 36,
        columnNumber: 11
      }
    }),
    "data-test-subj": "affectExistingSetupsWarningCheckbox",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 20,
      columnNumber: 5
    }
  });
};
exports.AffectExistingSetupsWarningCheckbox = AffectExistingSetupsWarningCheckbox;