"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MigrationCompletedModalStep = exports.MigrationCompletedFlyoutStep = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/upgrade_assistant/public/application/components/es_deprecations/deprecation_types/data_streams/flyout/steps/completed/completed_step.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MigrationCompleteStep = ({
  meta,
  resolutionType,
  dataStreamName
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("p", {
    "data-test-subj": "dataStreamMigrationCompletedDescription",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.dataStream.migration.completeStep.changesDescription",
    defaultMessage: "Success! {count, plural, =0 {backing indices} =1 {# backing index} other {# backing indices}} from {dataStreamName} successfully {resolutionType, select, reindex {reindexed} readonly {set to read-only} other {migrated}}.",
    values: {
      count: (meta === null || meta === void 0 ? void 0 : meta.indicesRequiringUpgradeCount) || 0,
      resolutionType,
      dataStreamName: dataStreamName && /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 52,
          columnNumber: 47
        }
      }, dataStreamName)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 9
    }
  })));
};
const MigrationCompletedFlyoutStep = ({
  meta,
  resolutionType,
  close,
  dataStreamName
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    "data-test-subj": "dataStreamMigrationCompletedTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.dataStream.migration.flyout.warningsStep.acceptChangesTitle",
    defaultMessage: "Data Stream Migration Complete",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(MigrationCompleteStep, {
    meta: meta,
    resolutionType: resolutionType,
    dataStreamName: dataStreamName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: close,
    flush: "left",
    "data-test-subj": "closeDataStreamReindexingButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.dataStream.migration.flyout.completedStep.closeButtonLabel",
    defaultMessage: "Close",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 15
    }
  }))))));
};
exports.MigrationCompletedFlyoutStep = MigrationCompletedFlyoutStep;
const MigrationCompletedModalStep = ({
  meta,
  resolutionType,
  close,
  dataStreamName
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    "data-test-subj": "readonlyDataStreamModalTitle",
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.dataStream.modal.completedStep.readonly.title",
    defaultMessage: "Setting data stream to read-only completed",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(MigrationCompleteStep, {
    meta: meta,
    resolutionType: resolutionType,
    dataStreamName: dataStreamName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: close,
    flush: "left",
    "data-test-subj": "closeDataStreamReindexingButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.dataStream.migration.modal.completedStep.closeButtonLabel",
    defaultMessage: "Close",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 15
    }
  }))))));
};
exports.MigrationCompletedModalStep = MigrationCompletedModalStep;