"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MigrationProgress = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _types = require("../../../../../../../../../common/types");
var _utils = require("../../../../../../../lib/utils");
var _progress_title = require("./progress_title");
var _types2 = require("../../../../../../types");
var _step_progress = require("../../../../../common/step_progress");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/upgrade_assistant/public/application/components/es_deprecations/deprecation_types/data_streams/flyout/steps/checklist/progress.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Displays a list of steps in the reindex operation, the current status, a progress bar,
 * and any error messages that are encountered.
 */
const MigrationProgress = props => {
  const {
    dataStreamName,
    migrationState: {
      status,
      taskPercComplete,
      cancelLoadingState,
      taskStatus,
      resolutionType
    }
  } = props;

  // The reindexing step is special because it generally lasts longer and can be cancelled mid-flight
  const reindexingDocsStep = {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      component: "span",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_progress_title.MigrateDocumentsStepTitle, (0, _extends2.default)({}, props, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 11
      }
    }))))
  };
  const inProgress = status === _types.DataStreamMigrationStatus.inProgress || status === _types.DataStreamMigrationStatus.completed;
  let euiProgressColor = 'subdued';
  if (cancelLoadingState === _types2.CancelLoadingState.Error) {
    reindexingDocsStep.status = 'failed';
    euiProgressColor = 'danger';
  } else if (cancelLoadingState === _types2.CancelLoadingState.Loading || cancelLoadingState === _types2.CancelLoadingState.Requested) {
    reindexingDocsStep.status = 'inProgress';
    euiProgressColor = 'subdued';
  } else if (status === _types.DataStreamMigrationStatus.failed) {
    reindexingDocsStep.status = 'failed';
    euiProgressColor = 'danger';
  } else if (status === _types.DataStreamMigrationStatus.cancelled || cancelLoadingState === _types2.CancelLoadingState.Success) {
    reindexingDocsStep.status = 'cancelled';
  } else if (status === undefined) {
    reindexingDocsStep.status = 'incomplete';
    euiProgressColor = 'subdued';
  } else if (status === _types.DataStreamMigrationStatus.inProgress) {
    reindexingDocsStep.status = 'inProgress';
    euiProgressColor = 'primary';
  } else if (status === _types.DataStreamMigrationStatus.completed) {
    reindexingDocsStep.status = 'complete';
    euiProgressColor = 'success';
  } else {
    // not started // undefined
    reindexingDocsStep.status = 'incomplete';
    euiProgressColor = 'subdued';
  }
  const progressPercentage = inProgress ? (0, _utils.getDataStreamReindexProgress)(status, taskPercComplete) : undefined;
  const showProgressValueText = inProgress;
  const progressMaxValue = inProgress ? 100 : undefined;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    "data-test-subj": "reindexChecklistTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 11
    }
  }, status === _types.DataStreamMigrationStatus.inProgress ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.dataStream.migration.flyout.checklistStep.reindexingInProgressTitle",
    defaultMessage: "{resolutionType, select, reindex {Reindexing} readonly {Setting to read-only} other {Migration}} {dataStreamName} in progress\u2026",
    values: {
      resolutionType,
      dataStreamName: dataStreamName && /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 111,
          columnNumber: 53
        }
      }, dataStreamName)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 15
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.dataStream.migration.flyout.checklistStep.reindexingChecklistTitle",
    defaultMessage: "{resolutionType, select, reindex {Reindex {dataStreamName}} readonly {Set {dataStreamName} to read-only} other {Migrate data stream}}",
    values: {
      resolutionType,
      dataStreamName: dataStreamName && /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 120,
          columnNumber: 53
        }
      }, dataStreamName)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 15
    }
  })))), inProgress && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    label: taskStatus ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.upgradeAssistant.dataStream.migration.flyout.checklistStep.reindexingInProgressTitle",
      defaultMessage: "Started {startTimeFromNow}",
      values: {
        startTimeFromNow: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelativeTime, {
          value: (taskStatus.startTimeMs - +(0, _moment.default)()) / 1000,
          updateIntervalInSeconds: 1,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 138,
            columnNumber: 23
          }
        })
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 17
      }
    }) : undefined,
    valueText: showProgressValueText,
    value: progressPercentage,
    max: progressMaxValue,
    color: euiProgressColor,
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_step_progress.StepProgress, {
    steps: [reindexingDocsStep],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 9
    }
  })), inProgress && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 9
    }
  }, !taskStatus && /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.dataStream.migration.flyout.checklistStep.fetchingStatus",
    defaultMessage: "Fetching Status\u2026",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 15
    }
  })), taskStatus && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs",
    style: {
      padding: '0 28px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 13
    }
  }, taskStatus.errorsCount > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 21
    }
  }, _i18n.i18n.translate('xpack.upgradeAssistant.dataStream.migration.flyout.checklistStep.progressStep.failedTitle', {
    defaultMessage: '{count, plural, =1 {# Index} other {# Indices}} failed to get {resolutionType, select, reindex {reindexed} readonly {set to read-only} other {migrated}}.',
    values: {
      count: taskStatus.errorsCount,
      resolutionType
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "success",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.upgradeAssistant.dataStream.migration.flyout.checklistStep.progressStep.completeTitle', {
    defaultMessage: '{count, plural, =1 {# Index} other {# Indices}} successfully {resolutionType, select, reindex {reindexed} readonly {set to read-only} other {migrated}}.',
    values: {
      count: taskStatus.successCount,
      resolutionType
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "primary",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.upgradeAssistant.dataStream.migration.flyout.checklistStep.progressStep.inProgressTitle', {
    defaultMessage: '{count, plural, =1 {# Index} other {# Indices}} currently getting {resolutionType, select, reindex {reindexed} readonly {set to read-only} other {migrated}}.',
    values: {
      count: taskStatus.inProgressCount,
      resolutionType
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.upgradeAssistant.dataStream.migration.flyout.checklistStep.progressStep.pendingTitle', {
    defaultMessage: '{count, plural, =1 {# Index} other {# Indices}} waiting to start.',
    values: {
      count: taskStatus.pendingCount
    }
  })))))));
};
exports.MigrationProgress = MigrationProgress;