"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataStreamReindexFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _analytics = require("@kbn/analytics");
var _moment = _interopRequireDefault(require("moment"));
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _i18n = require("@kbn/i18n");
var _types = require("../../../../../../../common/types");
var _shared = require("../../../../shared");
var _ui_metric = require("../../../../../lib/ui_metric");
var _messages = require("./messages");
var _confirm = require("./steps/confirm");
var _checklist = require("./steps/checklist");
var _completed = require("./steps/completed");
var _initializing_step = require("../../../common/initializing_step");
var _use_migration_step = require("../use_migration_step");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/upgrade_assistant/public/application/components/es_deprecations/deprecation_types/data_streams/flyout/container.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DATE_FORMAT = 'dddd, MMMM Do YYYY, h:mm:ss a';
const FILE_SIZE_DISPLAY_FORMAT = '0,0.[0] b';
const DataStreamReindexFlyout = ({
  cancelReindex,
  loadDataStreamMetadata,
  migrationState,
  startReindex,
  closeFlyout,
  deprecation
}) => {
  const {
    status,
    migrationWarnings,
    errorMessage,
    resolutionType,
    meta
  } = migrationState;
  const {
    index
  } = deprecation;
  const [flyoutStep, setFlyoutStep] = (0, _use_migration_step.useMigrationStep)(status, loadDataStreamMetadata);
  const onStartReindex = (0, _react.useCallback)(async () => {
    _ui_metric.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.CLICK, _ui_metric.UIM_DATA_STREAM_REINDEX_START_CLICK);
    await startReindex();
  }, [startReindex]);
  const onStopReindex = (0, _react.useCallback)(async () => {
    _ui_metric.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.CLICK, _ui_metric.UIM_DATA_STREAM_REINDEX_STOP_CLICK);
    await cancelReindex();
  }, [cancelReindex]);
  const {
    docsSizeFormatted,
    indicesRequiringUpgradeDocsCount,
    lastIndexCreationDateFormatted,
    oldestIncompatibleDocFormatted
  } = (0, _react.useMemo)(() => {
    if (!meta) {
      return {
        indicesRequiringUpgradeDocsCount: _messages.containerMessages.unknownMessage,
        docsSizeFormatted: _messages.containerMessages.unknownMessage,
        lastIndexCreationDateFormatted: _messages.containerMessages.unknownMessage,
        oldestIncompatibleDocFormatted: undefined
      };
    }
    return {
      indicesRequiringUpgradeDocsCount: typeof meta.indicesRequiringUpgradeDocsCount === 'number' ? `${meta.indicesRequiringUpgradeDocsCount}` : 'Unknown',
      docsSizeFormatted: typeof meta.indicesRequiringUpgradeDocsSize === 'number' ? (0, _numeral.default)(meta.indicesRequiringUpgradeDocsSize).format(FILE_SIZE_DISPLAY_FORMAT) : 'Unknown',
      lastIndexCreationDateFormatted: typeof meta.lastIndexRequiringUpgradeCreationDate === 'number' ? `${(0, _moment.default)(meta.lastIndexRequiringUpgradeCreationDate).format(DATE_FORMAT)}` : 'Unknown',
      oldestIncompatibleDocFormatted: typeof meta.oldestIncompatibleDocTimestamp === 'number' ? `${(0, _moment.default)(meta.oldestIncompatibleDocTimestamp).format(DATE_FORMAT)}` : undefined
    };
  }, [meta]);
  const flyoutContents = (0, _react.useMemo)(() => {
    switch (flyoutStep) {
      case 'initializing':
        return /*#__PURE__*/_react.default.createElement(_initializing_step.InitializingStep, {
          errorMessage: errorMessage,
          type: "dataStream",
          mode: "flyout",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 109,
            columnNumber: 16
          }
        });
      case 'confirm':
        {
          if (!meta || !resolutionType) {
            return /*#__PURE__*/_react.default.createElement(_initializing_step.InitializingStep, {
              errorMessage: errorMessage || _messages.containerMessages.errorLoadingDataStreamInfo,
              type: "dataStream",
              mode: "flyout",
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 113,
                columnNumber: 13
              }
            });
          }
          return /*#__PURE__*/_react.default.createElement(_confirm.ConfirmMigrationReindexFlyoutStep, {
            warnings: (migrationWarnings !== null && migrationWarnings !== void 0 ? migrationWarnings : []).filter(warning => warning.resolutionType === resolutionType),
            meta: meta,
            closeFlyout: closeFlyout,
            startAction: () => onStartReindex(),
            lastIndexCreationDateFormatted: lastIndexCreationDateFormatted,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 122,
              columnNumber: 11
            }
          });
        }
      case 'inProgress':
        {
          if (!resolutionType) {
            return /*#__PURE__*/_react.default.createElement(_initializing_step.InitializingStep, {
              errorMessage: errorMessage || _messages.containerMessages.errorLoadingDataStreamInfo,
              type: "dataStream",
              mode: "flyout",
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 136,
                columnNumber: 13
              }
            });
          }
          return /*#__PURE__*/_react.default.createElement(_checklist.ChecklistFlyoutStep, {
            closeFlyout: closeFlyout,
            executeAction: () => {
              setFlyoutStep('confirm');
            },
            migrationState: migrationState,
            cancelAction: () => onStopReindex(),
            dataStreamName: index,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 145,
              columnNumber: 11
            }
          });
        }
      case 'completed':
        {
          return /*#__PURE__*/_react.default.createElement(_completed.MigrationCompletedFlyoutStep, {
            meta: meta,
            resolutionType: resolutionType,
            close: closeFlyout,
            dataStreamName: index,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 158,
              columnNumber: 11
            }
          });
        }
    }
  }, [flyoutStep, errorMessage, meta, resolutionType, migrationWarnings, closeFlyout, lastIndexCreationDateFormatted, onStartReindex, migrationState, index, setFlyoutStep, onStopReindex]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, flyoutStep !== 'initializing' && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_shared.DeprecationBadge, {
    level: deprecation.level,
    isResolved: status === _types.DataStreamMigrationStatus.completed,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    "data-test-subj": "flyoutTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "reindexDetailsFlyoutTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 13
    }
  }, index)), meta && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse",
    "data-test-subj": "dataStreamLastIndexCreationDate",
    listItems: oldestIncompatibleDocFormatted ? [{
      title: _i18n.i18n.translate('xpack.upgradeAssistant.dataStream.flyout.container.oldestIncompatibleDoc', {
        defaultMessage: 'Migration required for data indexed on or before'
      }),
      description: oldestIncompatibleDocFormatted
    }] : [{
      title: _i18n.i18n.translate('xpack.upgradeAssistant.dataStream.flyout.container.affectedIndicesCreatedOnOrBefore', {
        defaultMessage: 'Migration required for indices created on or before'
      }),
      description: lastIndexCreationDateFormatted
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse",
    listItems: [{
      title: _i18n.i18n.translate('xpack.upgradeAssistant.dataStream.flyout.container.indicesDocsSize', {
        defaultMessage: 'Size'
      }),
      description: docsSizeFormatted
    }],
    "data-test-subj": "dataStreamSize",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse",
    listItems: [{
      title: _i18n.i18n.translate('xpack.upgradeAssistant.dataStream.flyout.container.indicesDocsCount', {
        defaultMessage: 'Document Count'
      }),
      description: indicesRequiringUpgradeDocsCount
    }],
    "data-test-subj": "dataStreamDocumentCount",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 21
    }
  })))))), flyoutContents);
};
exports.DataStreamReindexFlyout = DataStreamReindexFlyout;