"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataStreamReindexActionsCell = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _types = require("../../../../../../common/types");
var _context = require("./context");
var _types2 = require("../../../types");
var _action_buttons = require("../../common/action_buttons");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/upgrade_assistant/public/application/components/es_deprecations/deprecation_types/data_streams/actions_table_cell.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const actionsI18nTexts = {
  readOnlyTooltipLabel: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.dataStream.resolutionTooltipReadOnlyLabel', {
    defaultMessage: 'Resolve this issue by setting its indices to read-only.'
  }),
  reindexTooltipLabel: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.dataStream.resolutionTooltipReindexLabel', {
    defaultMessage: 'Resolve this issue by reindexing this data stream.'
  }),
  loadingStatusText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.dataStream.resolutionLoadingActionsText', {
    defaultMessage: 'Loading actions…'
  })
};
const DataStreamReindexActionsCell = ({
  correctiveAction,
  openFlyout,
  openModal
}) => {
  var _correctiveAction$met, _correctiveAction$met2;
  const {
    migrationState
  } = (0, _context.useDataStreamMigrationContext)();
  const reindexExcluded = (_correctiveAction$met = correctiveAction.metadata.excludedActions) === null || _correctiveAction$met === void 0 ? void 0 : _correctiveAction$met.includes('reindex');
  const readOnlyExcluded = (_correctiveAction$met2 = correctiveAction.metadata.excludedActions) === null || _correctiveAction$met2 === void 0 ? void 0 : _correctiveAction$met2.includes('readOnly');
  const migrationInProgressOrCompleted = migrationState.status === _types.DataStreamMigrationStatus.inProgress || migrationState.status === _types.DataStreamMigrationStatus.completed;
  const canDisplayReadOnly = !!(migrationState.hasRequiredPrivileges && !readOnlyExcluded && (!migrationInProgressOrCompleted || migrationInProgressOrCompleted && migrationState.resolutionType === 'readonly'));
  const canDisplayReindex = !!(migrationState.hasRequiredPrivileges && !reindexExcluded && (!migrationInProgressOrCompleted || migrationInProgressOrCompleted && migrationState.resolutionType === 'reindex'));
  const actions = [{
    tooltip: actionsI18nTexts.reindexTooltipLabel,
    iconType: 'indexSettings',
    canDisplay: canDisplayReindex,
    resolutionType: 'reindex',
    onClick: () => {
      openFlyout();
    }
  }, {
    tooltip: actionsI18nTexts.readOnlyTooltipLabel,
    iconType: 'readOnly',
    canDisplay: canDisplayReadOnly,
    resolutionType: 'readonly',
    onClick: () => {
      openModal();
    }
  }];
  if (migrationState.loadingState === _types2.LoadingState.Loading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 11
      }
    }, actionsI18nTexts.loadingStatusText)));
  }
  return /*#__PURE__*/_react.default.createElement(_action_buttons.ActionButtons, {
    actions: actions,
    dataTestSubjPrefix: correctiveAction.type,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 10
    }
  });
};
exports.DataStreamReindexActionsCell = DataStreamReindexActionsCell;