"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ClusterSettingsTableRow = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../shared_imports");
var _app_context = require("../../../../app_context");
var _es_deprecations_table_cells = require("../../es_deprecations_table_cells");
var _resolution_table_cell = require("./resolution_table_cell");
var _flyout = require("./flyout");
var _actions_table_cell = require("./actions_table_cell");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/upgrade_assistant/public/application/components/es_deprecations/deprecation_types/cluster_settings/table_row.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  useGlobalFlyout
} = _shared_imports.GlobalFlyout;
const ClusterSettingsTableRow = ({
  rowFieldNames,
  deprecation,
  index
}) => {
  const [showFlyout, setShowFlyout] = (0, _react.useState)(false);
  const [status, setStatus] = (0, _react.useState)({
    statusType: 'idle'
  });
  const {
    services: {
      api
    }
  } = (0, _app_context.useAppContext)();
  const {
    addContent: addContentToGlobalFlyout,
    removeContent: removeContentFromGlobalFlyout
  } = useGlobalFlyout();
  const closeFlyout = (0, _react.useCallback)(() => {
    setShowFlyout(false);
    removeContentFromGlobalFlyout('clusterSettingsFlyout');
  }, [removeContentFromGlobalFlyout]);
  const removeClusterSettings = (0, _react.useCallback)(async settings => {
    setStatus({
      statusType: 'in_progress'
    });
    const {
      error
    } = await api.updateClusterSettings(settings);
    setStatus({
      statusType: error ? 'error' : 'complete',
      details: error !== null && error !== void 0 ? error : undefined
    });
    closeFlyout();
  }, [api, closeFlyout]);
  (0, _react.useEffect)(() => {
    if (showFlyout) {
      addContentToGlobalFlyout({
        id: 'clusterSettingsFlyout',
        Component: _flyout.RemoveClusterSettingsFlyout,
        props: {
          closeFlyout,
          deprecation,
          removeClusterSettings,
          status
        },
        flyoutProps: {
          onClose: closeFlyout,
          className: 'eui-textBreakWord',
          'data-test-subj': 'clusterSettingsDetails',
          'aria-labelledby': 'removeClusterSettingsDetailsFlyoutTitle'
        }
      });
    }
  }, [addContentToGlobalFlyout, deprecation, removeClusterSettings, showFlyout, closeFlyout, status]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
    "data-test-subj": "deprecationTableRow",
    key: `deprecation-row-${index}`,
    onClick: () => setShowFlyout(true),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 5
    }
  }, rowFieldNames.map(field => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
      key: field,
      truncateText: false,
      "data-test-subj": `clusterSettingsTableCell-${field}`,
      align: field === 'actions' ? 'right' : 'left',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_es_deprecations_table_cells.EsDeprecationsTableCells, {
      fieldName: field,
      deprecation: deprecation,
      resolutionTableCell: /*#__PURE__*/_react.default.createElement(_resolution_table_cell.ClusterSettingsResolutionCell, {
        status: status,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 111,
          columnNumber: 36
        }
      }),
      actionsTableCell: /*#__PURE__*/_react.default.createElement(_actions_table_cell.ClusterSettingsActionsCell, {
        openFlyout: () => setShowFlyout(true),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 113,
          columnNumber: 17
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 13
      }
    }));
  }));
};
exports.ClusterSettingsTableRow = ClusterSettingsTableRow;