"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SaveQueryForm = SaveQueryForm;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_search/public/saved_query_form/save_query_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SaveQueryForm({
  savedQuery,
  savedQueryService,
  onSave,
  onClose,
  showFilterOption = true,
  showTimeFilterOption = true
}) {
  var _savedQuery$attribute;
  const [title, setTitle] = (0, _react.useState)((_savedQuery$attribute = savedQuery === null || savedQuery === void 0 ? void 0 : savedQuery.attributes.title) !== null && _savedQuery$attribute !== void 0 ? _savedQuery$attribute : '');
  const [shouldIncludeFilters, setShouldIncludeFilters] = (0, _react.useState)(Boolean(savedQuery ? savedQuery.attributes.filters : true));
  // Defaults to false because saved queries are meant to be as portable as possible and loading
  // a saved query with a time filter will override whatever the current value of the global timepicker
  // is. We expect this option to be used rarely and only when the user knows they want this behavior.
  const [shouldIncludeTimefilter, setIncludeTimefilter] = (0, _react.useState)(Boolean(savedQuery ? savedQuery.attributes.timefilter : false));
  const [formErrors, setFormErrors] = (0, _react.useState)([]);
  const [saveIsDisabled, setSaveIsDisabled] = (0, _react.useState)(false);
  const titleConflictErrorText = _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryForm.titleConflictText', {
    defaultMessage: 'Name conflicts with an existing query.'
  });
  const titleExistsErrorText = _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryForm.titleExistsText', {
    defaultMessage: 'Name is required.'
  });
  const validate = (0, _react.useCallback)(async () => {
    const errors = [];
    if (!title) {
      errors.push(titleExistsErrorText);
    }
    if (await savedQueryService.isDuplicateTitle(title, savedQuery === null || savedQuery === void 0 ? void 0 : savedQuery.id)) {
      errors.push(titleConflictErrorText);
    }
    if (!(0, _lodash.isEqual)(errors, formErrors)) {
      setFormErrors(errors);
      return false;
    }
    return !formErrors.length;
  }, [formErrors, savedQuery, savedQueryService, title, titleConflictErrorText, titleExistsErrorText]);
  const onClickSave = (0, _react.useCallback)(async () => {
    try {
      setSaveIsDisabled(true);
      if (await validate()) {
        onSave({
          id: savedQuery === null || savedQuery === void 0 ? void 0 : savedQuery.id,
          title,
          description: '',
          shouldIncludeFilters,
          shouldIncludeTimefilter
        });
        onClose();
      }
    } finally {
      setSaveIsDisabled(false);
    }
  }, [validate, onSave, onClose, savedQuery === null || savedQuery === void 0 ? void 0 : savedQuery.id, title, shouldIncludeFilters, shouldIncludeTimefilter]);
  const onInputChange = (0, _react.useCallback)(event => {
    setFormErrors([]);
    setTitle(event.target.value);
  }, []);
  const autoTrim = (0, _react.useCallback)(() => {
    const trimmedTitle = title.trim();
    if (title.length > trimmedTitle.length) {
      setTitle(trimmedTitle);
    }
  }, [title]);
  const hasErrors = formErrors.length > 0;
  const saveQueryForm = /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    isInvalid: hasErrors,
    error: formErrors,
    "data-test-subj": "saveQueryForm",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryNameLabelText', {
      defaultMessage: 'Name'
    }),
    isInvalid: hasErrors,
    display: "rowCompressed",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    disabled: !!savedQuery,
    value: title,
    name: "title",
    onChange: onInputChange,
    "data-test-subj": "saveQueryFormTitle",
    isInvalid: hasErrors,
    onBlur: autoTrim,
    compressed: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 9
    }
  })), showFilterOption && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "rowCompressed",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    name: "shouldIncludeFilters",
    label: _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryIncludeFiltersLabelText', {
      defaultMessage: 'Include filters'
    }),
    checked: shouldIncludeFilters,
    onChange: () => {
      setShouldIncludeFilters(!shouldIncludeFilters);
    },
    "data-test-subj": "saveQueryFormIncludeFiltersOption",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 11
    }
  })), showTimeFilterOption && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "rowCompressed",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    name: "shouldIncludeTimefilter",
    label: _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryIncludeTimeFilterLabelText', {
      defaultMessage: 'Include time filter'
    }),
    checked: shouldIncludeTimefilter,
    onChange: () => {
      setIncludeTimefilter(!shouldIncludeTimefilter);
    },
    "data-test-subj": "saveQueryFormIncludeTimeFilterOption",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fullWidth: true,
    size: "s",
    onClick: onClickSave,
    fill: true,
    "data-test-subj": "savedQueryFormSaveButton",
    disabled: hasErrors || saveIsDisabled,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('unifiedSearch.search.searchBar.savedQueryFormSaveButtonText', {
    defaultMessage: 'Save query'
  }))));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, saveQueryForm);
}