"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toUser = toUser;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Take text from the model and present it to the user as a string
 * @param text model value
 * @returns {string}
 */
function toUser(text) {
  if (text == null) {
    return '';
  }
  if (typeof text === 'object') {
    if (text.query_string) {
      return toUser(text.query_string.query);
    }
    return JSON.stringify(text);
  }
  return '' + text;
}