"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ESQLMenuPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _react2 = require("@emotion/react");
var _public = require("@kbn/kibana-react-plugin/public");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _i18n = require("@kbn/i18n");
var _esqlUtils = require("@kbn/esql-utils");
var _esqlTypes = require("@kbn/esql-types");
var _recommended_queries = require("@kbn/esql-ast/src/commands_registry/options/recommended_queries");
var _languageDocumentation = require("@kbn/language-documentation");
var _aiopsUtils = require("@kbn/aiops-utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_search/public/query_string_input/esql_menu_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ESQLMenuPopover = ({
  onESQLDocsFlyoutVisibilityChanged,
  adHocDataview,
  onESQLQuerySubmit
}) => {
  var _docLinks$links$query, _docLinks$links, _docLinks$links$query2;
  const kibana = (0, _public.useKibana)();
  const {
    docLinks,
    http,
    chrome
  } = kibana.services;
  const activeSolutionId = (0, _useObservable.default)(chrome.getActiveSolutionNavId$());
  const [isESQLMenuPopoverOpen, setIsESQLMenuPopoverOpen] = (0, _react.useState)(false);
  const [isLanguageComponentOpen, setIsLanguageComponentOpen] = (0, _react.useState)(false);
  const [solutionsRecommendedQueries, setSolutionsRecommendedQueries] = (0, _react.useState)([]);
  const {
    queryForRecommendedQueries,
    timeFieldName,
    categorizationField
  } = (0, _react.useMemo)(() => {
    if (adHocDataview && typeof adHocDataview !== 'string') {
      var _adHocDataview$fields, _adHocDataview$fields2, _adHocDataview$timeFi, _adHocDataview$fields3, _adHocDataview$fields4, _adHocDataview$fields5;
      const textFields = (_adHocDataview$fields = (_adHocDataview$fields2 = adHocDataview.fields) === null || _adHocDataview$fields2 === void 0 ? void 0 : _adHocDataview$fields2.getByType('string')) !== null && _adHocDataview$fields !== void 0 ? _adHocDataview$fields : [];
      let tempCategorizationField;
      if (textFields.length) {
        tempCategorizationField = (0, _aiopsUtils.getCategorizationField)(textFields.map(field => field.name));
      }
      return {
        queryForRecommendedQueries: `FROM ${adHocDataview.name}`,
        timeFieldName: (_adHocDataview$timeFi = adHocDataview.timeFieldName) !== null && _adHocDataview$timeFi !== void 0 ? _adHocDataview$timeFi : (_adHocDataview$fields3 = adHocDataview.fields) === null || _adHocDataview$fields3 === void 0 ? void 0 : (_adHocDataview$fields4 = _adHocDataview$fields3.getByType('date')) === null || _adHocDataview$fields4 === void 0 ? void 0 : (_adHocDataview$fields5 = _adHocDataview$fields4[0]) === null || _adHocDataview$fields5 === void 0 ? void 0 : _adHocDataview$fields5.name,
        categorizationField: tempCategorizationField
      };
    }
    return {
      queryForRecommendedQueries: '',
      timeFieldName: undefined,
      categorizationField: undefined
    };
  }, [adHocDataview]);

  // Use a ref to store the *previous* fetched recommended queries
  const lastFetchedQueries = (0, _react.useRef)([]);
  (0, _react.useEffect)(() => {
    let cancelled = false;
    const getESQLExtensions = async () => {
      if (!activeSolutionId || !queryForRecommendedQueries) {
        return; // Don't fetch if we don't have the active solution or query
      }
      try {
        const extensions = await http.get(`${_esqlTypes.REGISTRY_EXTENSIONS_ROUTE}${activeSolutionId}/${queryForRecommendedQueries}`);
        if (cancelled) return;

        // Only update state if the new data is actually different from the *last successfully set* data
        if (!(0, _lodash.isEqual)(extensions.recommendedQueries, lastFetchedQueries.current)) {
          setSolutionsRecommendedQueries(extensions.recommendedQueries);
          lastFetchedQueries.current = extensions.recommendedQueries; // Update the ref with the new data
        }
      } catch (error) {
        // Do nothing if the extensions are not available
      }
    };
    getESQLExtensions();
    return () => {
      cancelled = true;
    };
  }, [activeSolutionId, http, queryForRecommendedQueries]);
  const toggleLanguageComponent = (0, _react.useCallback)(() => {
    setIsLanguageComponentOpen(!isLanguageComponentOpen);
    setIsESQLMenuPopoverOpen(false);
  }, [isLanguageComponentOpen]);
  const onHelpMenuVisibilityChange = (0, _react.useCallback)(status => {
    setIsLanguageComponentOpen(status);
    onESQLDocsFlyoutVisibilityChanged === null || onESQLDocsFlyoutVisibilityChanged === void 0 ? void 0 : onESQLDocsFlyoutVisibilityChanged(status);
  }, [setIsLanguageComponentOpen, onESQLDocsFlyoutVisibilityChanged]);
  const esqlContextMenuPanels = (0, _react.useMemo)(() => {
    const recommendedQueries = [];
    // If there are specific recommended queries for the current solution, process them.
    if (solutionsRecommendedQueries.length) {
      // Extract the core query templates by removing the 'FROM' clause.
      const recommendedQueriesTemplatesFromExtensions = (0, _recommended_queries.getRecommendedQueriesTemplatesFromExtensions)(solutionsRecommendedQueries);

      // Construct the full recommended queries by prepending the base 'FROM' command
      // and add them to the main list of recommended queries.
      recommendedQueries.push(...recommendedQueriesTemplatesFromExtensions.map(template => ({
        label: template.label,
        queryString: `${queryForRecommendedQueries}${template.text}`
      })));
    }

    // Handle the static recommended queries, no solutions specific
    if (queryForRecommendedQueries && timeFieldName) {
      const recommendedQueriesFromStaticTemplates = (0, _recommended_queries.getRecommendedQueriesTemplates)({
        fromCommand: queryForRecommendedQueries,
        timeField: timeFieldName,
        categorizationField
      });
      recommendedQueries.push(...recommendedQueriesFromStaticTemplates);
    }
    const panels = [{
      id: 0,
      items: [{
        name: _i18n.i18n.translate('unifiedSearch.query.queryBar.esqlMenu.quickReference', {
          defaultMessage: 'Quick Reference'
        }),
        icon: 'nedocumentationsted',
        // Typo: Should be 'documentation'
        renderItem: () => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
          key: "quickReference",
          icon: "documentation",
          "data-test-subj": "esql-quick-reference",
          onClick: () => toggleLanguageComponent(),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 163,
            columnNumber: 15
          }
        }, _i18n.i18n.translate('unifiedSearch.query.queryBar.esqlMenu.quickReference', {
          defaultMessage: 'Quick Reference'
        }))
      }, {
        name: _i18n.i18n.translate('unifiedSearch.query.queryBar.esqlMenu.documentation', {
          defaultMessage: 'Documentation'
        }),
        icon: 'info',
        renderItem: () => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
          key: "about",
          icon: "info",
          "data-test-subj": "esql-about",
          target: "_blank",
          href: docLinks.links.query.queryESQL,
          onClick: () => setIsESQLMenuPopoverOpen(false),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 181,
            columnNumber: 15
          }
        }, _i18n.i18n.translate('unifiedSearch.query.queryBar.esqlMenu.documentation', {
          defaultMessage: 'Documentation'
        }))
      }, ...(Boolean(recommendedQueries.length) ? [{
        name: _i18n.i18n.translate('unifiedSearch.query.queryBar.esqlMenu.exampleQueries', {
          defaultMessage: 'Recommended queries'
        }),
        icon: 'nested',
        panel: 1,
        'data-test-subj': 'esql-recommended-queries'
      }] : []), {
        name: _i18n.i18n.translate('unifiedSearch.query.queryBar.esqlMenu.feedback', {
          defaultMessage: 'Submit feedback'
        }),
        icon: 'editorComment',
        renderItem: () => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
          key: "feedback",
          icon: "editorComment",
          "data-test-subj": "esql-feedback",
          target: "_blank",
          href: _esqlUtils.FEEDBACK_LINK,
          onClick: () => setIsESQLMenuPopoverOpen(false),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 213,
            columnNumber: 15
          }
        }, _i18n.i18n.translate('unifiedSearch.query.queryBar.esqlMenu.feedback', {
          defaultMessage: 'Submit feedback'
        }))
      }]
    }, {
      id: 1,
      title: _i18n.i18n.translate('unifiedSearch.query.queryBar.esqlMenu.exampleQueries', {
        defaultMessage: 'Recommended queries'
      }),
      items: recommendedQueries.map(query => {
        return {
          name: query.label,
          onClick: () => {
            onESQLQuerySubmit === null || onESQLQuerySubmit === void 0 ? void 0 : onESQLQuerySubmit(query.queryString);
            setIsESQLMenuPopoverOpen(false);
          }
        };
      })
    }];
    return panels;
  }, [docLinks.links.query.queryESQL, onESQLQuerySubmit, queryForRecommendedQueries, timeFieldName, toggleLanguageComponent, solutionsRecommendedQueries,
  // This dependency is fine here, as it *uses* the state
  categorizationField]);
  const esqlMenuPopoverStyles = (0, _react2.css)`
    width: 240px;
    max-height: 350px;
    overflow-y: auto;
    ${(0, _eui.useEuiScrollBar)()};
  `;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "text",
      onClick: () => setIsESQLMenuPopoverOpen(!isESQLMenuPopoverOpen),
      "data-test-subj": "esql-menu-button",
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 267,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('unifiedSearch.query.queryBar.esqlMenu.label', {
      defaultMessage: 'ES|QL help'
    })),
    panelProps: {
      ['data-test-subj']: 'esql-menu-popover',
      css: esqlMenuPopoverStyles
    },
    isOpen: isESQLMenuPopoverOpen,
    closePopover: () => setIsESQLMenuPopoverOpen(false),
    panelPaddingSize: "s",
    display: "block",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: esqlContextMenuPanels,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 287,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_languageDocumentation.LanguageDocumentationFlyout, {
    searchInDescription: true,
    linkToDocumentation: (_docLinks$links$query = docLinks === null || docLinks === void 0 ? void 0 : (_docLinks$links = docLinks.links) === null || _docLinks$links === void 0 ? void 0 : (_docLinks$links$query2 = _docLinks$links.query) === null || _docLinks$links$query2 === void 0 ? void 0 : _docLinks$links$query2.queryESQL) !== null && _docLinks$links$query !== void 0 ? _docLinks$links$query : '',
    isHelpMenuOpen: isLanguageComponentOpen,
    onHelpMenuVisibilityChange: onHelpMenuVisibilityChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 289,
      columnNumber: 7
    }
  }));
};
exports.ESQLMenuPopover = ESQLMenuPopover;