"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.strings = exports.AddFilterPopover = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _filter_editor_wrapper = require("./filter_editor_wrapper");
var _filter_editor = require("../filter_bar/filter_editor");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_search/public/query_string_input/add_filter_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const strings = exports.strings = {
  getAddFilterButtonLabel: () => _i18n.i18n.translate('unifiedSearch.filter.filterBar.addFilterButtonLabel', {
    defaultMessage: 'Add filter'
  })
};
const customButtonStyles = (0, _react2.css)({
  borderTopLeftRadius: 0,
  borderBottomLeftRadius: 0
});
const AddFilterPopoverComponent = /*#__PURE__*/_react.default.memo(function AddFilterPopover({
  indexPatterns,
  filters,
  timeRangeForSuggestionsOverride,
  filtersForSuggestions,
  onFiltersUpdated,
  buttonProps,
  isDisabled,
  onCloseFilterPopover,
  onLocalFilterUpdate,
  onLocalFilterCreate,
  suggestionsAbstraction
}) {
  const [showAddFilterPopover, setShowAddFilterPopover] = (0, _react.useState)(false);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    delay: "long",
    content: strings.getAddFilterButtonLabel(),
    disableScreenReaderOutput: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
    display: "base",
    iconType: "plusInCircleFilled",
    "aria-label": strings.getAddFilterButtonLabel(),
    "data-test-subj": "addFilter",
    onClick: () => setShowAddFilterPopover(isOpen => !isOpen),
    size: "s",
    disabled: isDisabled
  }, buttonProps, {
    css: [buttonProps === null || buttonProps === void 0 ? void 0 : buttonProps.css, customButtonStyles],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  })));
  const closePopover = (0, _react.useCallback)(() => {
    onCloseFilterPopover([() => setShowAddFilterPopover(false)]);
  }, [onCloseFilterPopover]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "addFilterPopover",
    button: button,
    isOpen: showAddFilterPopover,
    closePopover: closePopover,
    anchorPosition: "downLeft",
    panelPaddingSize: "none",
    panelProps: {
      'data-test-subj': 'addFilterPopover'
    },
    initialFocus: ".filterEditor__hiddenItem",
    ownFocus: true,
    repositionOnScroll: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_filter_editor_wrapper.FilterEditorWrapper, {
    indexPatterns: indexPatterns,
    filters: filters,
    timeRangeForSuggestionsOverride: timeRangeForSuggestionsOverride,
    filtersForSuggestions: filtersForSuggestions,
    onFiltersUpdated: onFiltersUpdated,
    onLocalFilterUpdate: onLocalFilterUpdate,
    onLocalFilterCreate: onLocalFilterCreate,
    closePopoverOnAdd: () => {
      setShowAddFilterPopover(false);
    },
    closePopoverOnCancel: () => {
      setShowAddFilterPopover(false);
    },
    suggestionsAbstraction: suggestionsAbstraction,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 9
    }
  })));
});
const AddFilterPopover = exports.AddFilterPopover = (0, _filter_editor.withCloseFilterEditorConfirmModal)(AddFilterPopoverComponent);