"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ParamsEditor = ParamsEditor;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lib = require("../../filter_bar/filter_editor/lib");
var _context = require("../context");
var _params_editor_input = require("./params_editor_input");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_search/public/filters_builder/filter_item/params_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ParamsEditor({
  dataView,
  field,
  operator,
  params,
  onHandleParamsChange,
  onHandleParamsUpdate,
  timeRangeForSuggestionsOverride,
  filtersForSuggestions
}) {
  const {
    disabled,
    suggestionsAbstraction
  } = (0, _react.useContext)(_context.FiltersBuilderContextType);
  const onParamsChange = (0, _react.useCallback)(selectedParams => {
    onHandleParamsChange(selectedParams);
  }, [onHandleParamsChange]);
  const onParamsUpdate = (0, _react.useCallback)(value => {
    onHandleParamsUpdate(value);
  }, [onHandleParamsUpdate]);
  const {
    isInvalid,
    errorMessage
  } = (0, _lib.getFieldValidityAndErrorMessage)(field, typeof params === 'string' ? params : undefined);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    isInvalid: isInvalid,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "bottom",
    content: errorMessage !== null && errorMessage !== void 0 ? errorMessage : null,
    display: "block",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_params_editor_input.ParamsEditorInput, {
    field: field,
    params: params,
    operator: operator,
    invalid: isInvalid,
    disabled: disabled,
    dataView: dataView,
    onParamsChange: onParamsChange,
    onParamsUpdate: onParamsUpdate,
    timeRangeForSuggestionsOverride: timeRangeForSuggestionsOverride,
    filtersForSuggestions: filtersForSuggestions,
    suggestionsAbstraction: suggestionsAbstraction,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 9
    }
  })));
}