"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldInput = FieldInput;
exports.strings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _fieldUtils = require("@kbn/field-utils");
var _reactField = require("@kbn/react-field");
var _calculateWidthFromCharCount = require("@kbn/calculate-width-from-char-count");
var _eui = require("@elastic/eui");
var _filter_editor = require("../../filter_bar/filter_editor");
var _context = require("../context");
var _helpers = require("../../filter_bar/filter_editor/lib/helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_search/public/filters_builder/filter_item/field_input.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const strings = exports.strings = {
  getFieldSelectPlaceholderLabel: () => _i18n.i18n.translate('unifiedSearch.filter.filtersBuilder.fieldSelectPlaceholder', {
    defaultMessage: 'Select a field'
  })
};
function FieldInput({
  field,
  dataView,
  onHandleField
}) {
  const {
    disabled,
    suggestionsAbstraction
  } = (0, _react.useContext)(_context.FiltersBuilderContextType);
  const fields = dataView ? (0, _filter_editor.getFilterableFields)(dataView) : [];
  const id = (0, _eui.useGeneratedHtmlId)({
    prefix: 'fieldInput'
  });
  const inputRef = (0, _react.useRef)(null);
  const onFieldChange = (0, _react.useCallback)(([selectedField]) => {
    onHandleField(selectedField);
  }, [onHandleField]);
  const getLabel = (0, _react.useCallback)(dataViewField => {
    let label = dataViewField.customLabel || dataViewField.name;
    if (suggestionsAbstraction !== null && suggestionsAbstraction !== void 0 && suggestionsAbstraction.fields[dataViewField.name]) {
      var _suggestionsAbstracti, _suggestionsAbstracti2;
      label = (_suggestionsAbstracti = suggestionsAbstraction === null || suggestionsAbstraction === void 0 ? void 0 : (_suggestionsAbstracti2 = suggestionsAbstraction.fields[dataViewField.name]) === null || _suggestionsAbstracti2 === void 0 ? void 0 : _suggestionsAbstracti2.displayField) !== null && _suggestionsAbstracti !== void 0 ? _suggestionsAbstracti : label;
    }
    return {
      label,
      name: dataViewField.name,
      value: dataViewField.type,
      prepend: /*#__PURE__*/_react.default.createElement(_reactField.FieldIcon, {
        type: dataViewField.type,
        fill: "none",
        className: "eui-alignMiddle",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 62,
          columnNumber: 18
        }
      })
    };
  }, [suggestionsAbstraction]);
  const optionFields = fields.map(getLabel);
  const euiOptions = optionFields;
  const selectedEuiOptions = (field ? [field] : []).filter(option => fields.indexOf(option) !== -1).map(option => euiOptions[fields.indexOf(option)]);
  const onComboBoxChange = newOptions => {
    const newValues = newOptions.map(({
      label
    }) => fields[optionFields.findIndex(optionField => optionField.label === label)]);
    onFieldChange(newValues);
  };
  const panelMinWidth = (0, _calculateWidthFromCharCount.calculateWidthFromEntries)(euiOptions, ['label']);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    id: id,
    inputRef: ref => {
      inputRef.current = ref;
    },
    optionMatcher: _fieldUtils.comboBoxFieldOptionMatcher,
    options: euiOptions,
    selectedOptions: selectedEuiOptions,
    onChange: onComboBoxChange,
    isDisabled: disabled,
    placeholder: strings.getFieldSelectPlaceholderLabel(),
    sortMatchesBy: "startsWith",
    "aria-label": strings.getFieldSelectPlaceholderLabel(),
    isClearable: false,
    compressed: true,
    fullWidth: true,
    "data-test-subj": "filterFieldSuggestionList",
    singleSelection: _helpers.SINGLE_SELECTION_AS_TEXT_PROPS,
    truncationProps: _helpers.MIDDLE_TRUNCATION_PROPS,
    inputPopoverProps: {
      panelMinWidth
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 5
    }
  });
}