"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterItemActions = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _tooltip = require("../tooltip");
var _action_strings = require("./action_strings");
var _filter_item = require("../filter_item.styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_search/public/filters_builder/filter_item/actions/actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const FilterItemActions = ({
  disabled = false,
  disableRemove = false,
  hideOr = false,
  disableOr = false,
  hideAnd = false,
  disableAnd = false,
  minimizePaddings = false,
  onRemoveFilter,
  onOrButtonClick,
  onAddButtonClick
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const actionButtonClassName = (0, _filter_item.actionButtonCss)(euiTheme);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "flexEnd",
    gutterSize: "xs",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_tooltip.Tooltip, {
    content: _action_strings.strings.getDeleteButtonDisabled(),
    show: disableRemove || disabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: onRemoveFilter,
    iconType: "trash",
    isDisabled: disableRemove || disabled,
    size: "xs",
    color: "danger",
    "aria-label": _action_strings.strings.getDeleteFilterGroupButtonIconLabel()
    // EuiButtonIcon has no padding to minimize
    ,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 11
    }
  }))), !hideOr && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onOrButtonClick,
    isDisabled: disableOr || disabled,
    iconType: "plusInCircle",
    size: "xs",
    iconSize: "s",
    flush: "right",
    "aria-label": _action_strings.strings.getAddOrFilterGroupButtonIconLabel(),
    "data-test-subj": "add-or-filter",
    className: minimizePaddings ? actionButtonClassName : '',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 11
    }
  }, _action_strings.strings.getAddOrFilterGroupButtonLabel())), !hideAnd && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onAddButtonClick,
    isDisabled: disableAnd || disabled,
    iconType: "plusInCircle",
    size: "xs",
    iconSize: "s",
    flush: "right",
    "aria-label": _action_strings.strings.getAddAndFilterGroupButtonIconLabel(),
    "data-test-subj": "add-and-filter",
    className: minimizePaddings ? actionButtonClassName : '',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 11
    }
  }, _action_strings.strings.getAddAndFilterGroupButtonLabel())));
};
exports.FilterItemActions = FilterItemActions;