"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterBar = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _filter_items = require("./filter_item/filter_items");
var _filter_bar = require("./filter_bar.styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_search/public/filter_bar/filter_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FilterBarUI = /*#__PURE__*/_react.default.memo(function FilterBarUI(props) {
  var _props$className;
  const euiTheme = (0, _eui.useEuiTheme)();
  const styles = (0, _filter_bar.filterBarStyles)(euiTheme, props.afterQueryBar);
  const groupRef = (0, _react.useRef)(null);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: styles.group,
    ref: groupRef,
    wrap: true,
    responsive: false,
    gutterSize: "none" // We use `gap` in the styles instead for better truncation of badges
    ,
    alignItems: "center",
    tabIndex: -1,
    "data-test-subj": "filter-items-group",
    className: `filter-items-group ${(_props$className = props.className) !== null && _props$className !== void 0 ? _props$className : ''}`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 5
    }
  }, props.prepend, /*#__PURE__*/_react.default.createElement(_filter_items.FilterItems, {
    filters: props.filters,
    onFiltersUpdated: props.onFiltersUpdated,
    indexPatterns: props.indexPatterns,
    timeRangeForSuggestionsOverride: props.timeRangeForSuggestionsOverride,
    filtersForSuggestions: props.filtersForSuggestions,
    hiddenPanelOptions: props.hiddenPanelOptions,
    readOnly: props.isDisabled,
    suggestionsAbstraction: props.suggestionsAbstraction,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }));
});
const FilterBar = exports.FilterBar = (0, _i18nReact.injectI18n)(FilterBarUI);