"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChangeDataView = ChangeDataView;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _adhoc = _interopRequireDefault(require("./assets/adhoc.svg"));
var _change_dataview = require("./change_dataview.styles");
var _data_view_selector = require("./data_view_selector");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_search/public/dataview_picker/change_dataview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const mapAdHocDataView = adHocDataView => ({
  title: adHocDataView.title,
  name: adHocDataView.name,
  id: adHocDataView.id,
  type: adHocDataView.type,
  isAdhoc: true,
  managed: adHocDataView.managed
});
const shrinkableContainerCss = (0, _react2.css)`
  min-width: 0;
  flex-direction: row;
`;
function ChangeDataView({
  isMissingCurrent,
  currentDataViewId,
  adHocDataViews,
  savedDataViews,
  onChangeDataView,
  onAddField,
  onDataViewCreated,
  trigger,
  selectableProps,
  isDisabled,
  onEditDataView,
  onCreateDefaultAdHocDataView,
  onClosePopover,
  getDataViewHelpText
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isPopoverOpen, setPopoverIsOpen] = (0, _react.useState)(false);
  const [dataViewsList, setDataViewsList] = (0, _react.useState)([]);
  const kibana = (0, _public.useKibana)();
  const {
    application,
    data,
    dataViews,
    dataViewEditor
  } = kibana.services;
  const isMobile = (0, _eui.useIsWithinBreakpoints)(['xs']);
  const styles = (0, _change_dataview.changeDataViewStyles)({
    fullWidth: trigger.fullWidth,
    dataViewsList,
    theme: euiTheme,
    isMobile
  });

  // Create a reusable id to ensure search input is the first focused item in the popover even though it's not the first item
  const searchListInputId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'dataviewPickerListSearchInput'
  });
  const closePopover = (0, _react.useCallback)(() => {
    setPopoverIsOpen(false);
    if (onClosePopover) {
      onClosePopover();
    }
  }, [onClosePopover]);
  (0, _react.useEffect)(() => {
    const fetchDataViews = async () => {
      var _await$data$dataViews, _adHocDataViews$map;
      const savedDataViewRefs = savedDataViews ? savedDataViews : (_await$data$dataViews = await data.dataViews.getIdsWithTitle()) !== null && _await$data$dataViews !== void 0 ? _await$data$dataViews : [];
      const adHocDataViewRefs = (_adHocDataViews$map = adHocDataViews === null || adHocDataViews === void 0 ? void 0 : adHocDataViews.map(mapAdHocDataView)) !== null && _adHocDataViews$map !== void 0 ? _adHocDataViews$map : [];
      setDataViewsList([...savedDataViewRefs, ...adHocDataViewRefs]);
    };
    fetchDataViews();
  }, [data, currentDataViewId, adHocDataViews, savedDataViews]);
  const isAdHocSelected = (0, _react.useMemo)(() => {
    return adHocDataViews === null || adHocDataViews === void 0 ? void 0 : adHocDataViews.some(dataView => dataView.id === currentDataViewId);
  }, [adHocDataViews, currentDataViewId]);
  const closeDataViewEditor = (0, _react.useRef)();
  (0, _react.useEffect)(() => {
    return () => {
      // Make sure to close the editors when unmounting
      if (closeDataViewEditor.current) {
        closeDataViewEditor.current();
      }
    };
  }, []);
  const createTrigger = function () {
    const {
      label,
      title,
      'data-test-subj': dataTestSubj,
      fullWidth,
      ...rest
    } = trigger;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
      css: styles.trigger,
      "data-test-subj": dataTestSubj,
      onClick: () => {
        setPopoverIsOpen(!isPopoverOpen);
      },
      color: isMissingCurrent ? 'danger' : 'text',
      iconSide: "right",
      iconType: "arrowDown",
      title: trigger.label,
      disabled: isDisabled,
      textProps: {
        className: 'eui-textTruncate'
      },
      size: "s"
    }, rest, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 7
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      responsive: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 9
      }
    }, isAdHocSelected && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: _adhoc.default,
      color: "primary",
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 11
      }
    }, trigger.label)));
  };
  const onDuplicate = (0, _react.useCallback)(async () => {
    if (!currentDataViewId || !onDataViewCreated) {
      return;
    }
    const dataView = await dataViews.get(currentDataViewId);
    const editData = await dataViews.create({
      ...dataView.toSpec(),
      id: undefined,
      version: undefined,
      managed: false
    });
    closeDataViewEditor.current = dataViewEditor.openEditor({
      editData,
      onSave: newDataView => {
        onDataViewCreated(newDataView);
      },
      allowAdHocDataView: true,
      isDuplicating: true
    });
  }, [currentDataViewId, dataViews, dataViewEditor, onDataViewCreated]);
  const onEdit = (0, _react.useCallback)(async () => {
    if (onEditDataView && currentDataViewId) {
      const dataView = await dataViews.get(currentDataViewId);
      closeDataViewEditor.current = dataViewEditor.openEditor({
        editData: dataView,
        onSave: updatedDataView => {
          onEditDataView(updatedDataView);
        },
        onDuplicate,
        getDataViewHelpText
      });
    } else {
      application.navigateToApp('management', {
        path: `/kibana/indexPatterns/patterns/${currentDataViewId}`
      });
    }
    closePopover();
  }, [currentDataViewId, dataViews, onEditDataView, dataViewEditor, application, closePopover, onDuplicate, getDataViewHelpText]);
  const onCreate = (0, _react.useCallback)(() => {
    if (onDataViewCreated) {
      closeDataViewEditor.current = dataViewEditor.openEditor({
        onSave: newDataView => {
          onDataViewCreated(newDataView);
        },
        allowAdHocDataView: true
      });
    }
    closePopover();
  }, [onDataViewCreated, dataViewEditor, closePopover]);
  const items = (0, _react.useMemo)(() => {
    const panelItems = [];
    if (onAddField) {
      panelItems.push(/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: "add",
        icon: "indexOpen",
        "data-test-subj": "indexPattern-add-field",
        onClick: () => {
          closePopover();
          onAddField();
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 216,
          columnNumber: 9
        }
      }, _i18n.i18n.translate('unifiedSearch.query.queryBar.indexPattern.addFieldButton', {
        defaultMessage: 'Add a field to this data view'
      })), onEditDataView || dataViewEditor.userPermissions.editDataView() ? /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: "manage",
        icon: "indexSettings",
        "data-test-subj": "indexPattern-manage-field",
        onClick: onEdit,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 230,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('unifiedSearch.query.queryBar.indexPattern.manageFieldButton', {
        defaultMessage: 'Manage this data view'
      })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
        key: "empty",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 241,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
        margin: "none",
        key: "dataviewActions-divider",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 243,
          columnNumber: 9
        }
      }));
    }
    panelItems.push(/*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: "add-dataview",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 247,
        columnNumber: 7
      }
    }, onDataViewCreated && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "none",
      justifyContent: "spaceBetween",
      responsive: false,
      css: (0, _react2.css)`
              margin: ${euiTheme.size.s};
              margin-bottom: 0;
            `,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 249,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 259,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "xs",
      responsive: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 260,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 261,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 262,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement("h5", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 263,
        columnNumber: 21
      }
    }, _i18n.i18n.translate('unifiedSearch.query.queryBar.indexPattern.dataViewsLabel', {
      defaultMessage: 'Data views'
    })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 272,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: onCreate,
      size: "xs",
      iconType: "plusInCircleFilled",
      iconSide: "left",
      "data-test-subj": "dataview-create-new",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 273,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('unifiedSearch.query.queryBar.indexPattern.addNewDataView', {
      defaultMessage: 'Create a data view'
    })))), /*#__PURE__*/_react.default.createElement(_data_view_selector.DataViewSelector, {
      currentDataViewId: currentDataViewId,
      searchListInputId: searchListInputId,
      dataViewsList: dataViewsList,
      selectableProps: selectableProps,
      setPopoverIsOpen: setPopoverIsOpen,
      onChangeDataView: async newId => {
        closePopover();
        onChangeDataView(newId);
      },
      onCreateDefaultAdHocDataView: onCreateDefaultAdHocDataView,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 287,
        columnNumber: 9
      }
    })));
    return panelItems;
  }, [closePopover, currentDataViewId, dataViewEditor, dataViewsList, euiTheme.size.s, onAddField, onChangeDataView, onCreateDefaultAdHocDataView, onCreate, onDataViewCreated, onEdit, onEditDataView, searchListInputId, selectableProps]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 321,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    css: shrinkableContainerCss,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 323,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 324,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react2.css)`
                padding: 0 ${euiTheme.size.s};
                height: 100%;
                border-radius: ${euiTheme.border.radius.small} 0 0 ${euiTheme.border.radius.small};
                background-color: ${euiTheme.colors.lightestShade};
                border: ${euiTheme.border.width.thin} solid ${euiTheme.colors.borderBasePlain};
                border-right: 0;
                justify-content: center;
              `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 325,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 337,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('unifiedSearch.query.queryBar.esqlMenu.switcherLabelTitle', {
    defaultMessage: 'Data view'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    css: shrinkableContainerCss,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 343,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    panelClassName: "changeDataViewPopover",
    button: createTrigger(),
    panelProps: {
      ['data-test-subj']: 'changeDataViewPopover'
    },
    isOpen: isPopoverOpen,
    closePopover: () => setPopoverIsOpen(false),
    panelPaddingSize: "none",
    initialFocus: `[id="${searchListInputId}"]`,
    display: "block",
    buffer: 8,
    css: {
      inlineSize: '100%'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 344,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: styles.popoverContent,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 358,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: items,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 359,
      columnNumber: 19
    }
  }))))))));
}