"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupGetOperatorSuggestions = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _query_suggestion_provider = require("../query_suggestion_provider");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_search/public/autocomplete/providers/kql_query_suggestion/operator.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const equalsText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "unifiedSearch.kueryAutocomplete.equalOperatorDescription.equalsText",
  defaultMessage: "equals",
  description: "Part of unifiedSearch.kueryAutocomplete.equalOperatorDescription. Full text: 'equals some value'",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 19,
    columnNumber: 3
  }
});
const lessThanOrEqualToText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "unifiedSearch.kueryAutocomplete.lessThanOrEqualOperatorDescription.lessThanOrEqualToText",
  defaultMessage: "less than or equal to",
  description: "Part of unifiedSearch.kueryAutocomplete.lessThanOrEqualOperatorDescription. Full text: 'is less than or equal to some value'",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 26,
    columnNumber: 3
  }
});
const greaterThanOrEqualToText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "unifiedSearch.kueryAutocomplete.greaterThanOrEqualOperatorDescription.greaterThanOrEqualToText",
  defaultMessage: "greater than or equal to",
  description: "Part of unifiedSearch.kueryAutocomplete.greaterThanOrEqualOperatorDescription. Full text: 'is greater than or equal to some value'",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 33,
    columnNumber: 3
  }
});
const lessThanText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "unifiedSearch.kueryAutocomplete.lessThanOperatorDescription.lessThanText",
  defaultMessage: "less than",
  description: "Part of unifiedSearch.kueryAutocomplete.lessThanOperatorDescription. Full text: 'is less than some value'",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 40,
    columnNumber: 3
  }
});
const greaterThanText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "unifiedSearch.kueryAutocomplete.greaterThanOperatorDescription.greaterThanText",
  defaultMessage: "greater than",
  description: "Part of unifiedSearch.kueryAutocomplete.greaterThanOperatorDescription. Full text: 'is greater than some value'",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 47,
    columnNumber: 3
  }
});
const existsText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "unifiedSearch.kueryAutocomplete.existOperatorDescription.existsText",
  defaultMessage: "exists",
  description: "Part of unifiedSearch.kueryAutocomplete.existOperatorDescription. Full text: 'exists in any form'",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 54,
    columnNumber: 3
  }
});
const operators = {
  ':': {
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "unifiedSearch.kueryAutocomplete.equalOperatorDescription",
      defaultMessage: "{equals} some value",
      values: {
        equals: /*#__PURE__*/_react.default.createElement("span", {
          className: "kbnSuggestionItem__callout",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 67,
            columnNumber: 27
          }
        }, equalsText)
      },
      description: "Full text: 'equals some value'. See 'unifiedSearch.kueryAutocomplete.equalOperatorDescription.equalsText' for 'equals' part.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 7
      }
    }),
    fieldTypes: ['string', 'number', 'number_range', 'date', 'date_range', 'ip', 'ip_range', 'geo_point', 'geo_shape', 'boolean']
  },
  '<=': {
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "unifiedSearch.kueryAutocomplete.lessThanOrEqualOperatorDescription",
      defaultMessage: "is {lessThanOrEqualTo} some value",
      values: {
        lessThanOrEqualTo: /*#__PURE__*/_react.default.createElement("span", {
          className: "kbnSuggestionItem__callout",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 92,
            columnNumber: 13
          }
        }, lessThanOrEqualToText)
      },
      description: "Full text: 'is less than or equal to some value'. See 'unifiedSearch.kueryAutocomplete.lessThanOrEqualOperatorDescription.lessThanOrEqualToText' for 'less than or equal to' part.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 7
      }
    }),
    fieldTypes: ['number', 'number_range', 'date', 'date_range', 'ip', 'ip_range']
  },
  '>=': {
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "unifiedSearch.kueryAutocomplete.greaterThanOrEqualOperatorDescription",
      defaultMessage: "is {greaterThanOrEqualTo} some value",
      values: {
        greaterThanOrEqualTo: /*#__PURE__*/_react.default.createElement("span", {
          className: "kbnSuggestionItem__callout",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 108,
            columnNumber: 13
          }
        }, greaterThanOrEqualToText)
      },
      description: "Full text: 'is greater than or equal to some value'. See 'unifiedSearch.kueryAutocomplete.greaterThanOrEqualOperatorDescription.greaterThanOrEqualToText' for 'greater than or equal to' part.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 7
      }
    }),
    fieldTypes: ['number', 'number_range', 'date', 'date_range', 'ip', 'ip_range']
  },
  '<': {
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "unifiedSearch.kueryAutocomplete.lessThanOperatorDescription",
      defaultMessage: "is {lessThan} some value",
      values: {
        lessThan: /*#__PURE__*/_react.default.createElement("span", {
          className: "kbnSuggestionItem__callout",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 122,
            columnNumber: 29
          }
        }, lessThanText)
      },
      description: "Full text: 'is less than some value'. See 'unifiedSearch.kueryAutocomplete.lessThanOperatorDescription.lessThanText' for 'less than' part.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 7
      }
    }),
    fieldTypes: ['number', 'number_range', 'date', 'date_range', 'ip', 'ip_range']
  },
  '>': {
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "unifiedSearch.kueryAutocomplete.greaterThanOperatorDescription",
      defaultMessage: "is {greaterThan} some value",
      values: {
        greaterThan: /*#__PURE__*/_react.default.createElement("span", {
          className: "kbnSuggestionItem__callout",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 135,
            columnNumber: 24
          }
        }, greaterThanText)
      },
      description: "Full text: 'is greater than some value'. See 'unifiedSearch.kueryAutocomplete.greaterThanOperatorDescription.greaterThanText' for 'greater than' part.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 7
      }
    }),
    fieldTypes: ['number', 'number_range', 'date', 'date_range', 'ip', 'ip_range']
  },
  ': *': {
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "unifiedSearch.kueryAutocomplete.existOperatorDescription",
      defaultMessage: "{exists} in any form",
      values: {
        exists: /*#__PURE__*/_react.default.createElement("span", {
          className: "kbnSuggestionItem__callout",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 148,
            columnNumber: 27
          }
        }, existsText)
      },
      description: "Full text: 'exists in any form'. See 'unifiedSearch.kueryAutocomplete.existOperatorDescription.existsText' for 'exists' part.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 7
      }
    }),
    fieldTypes: undefined
  }
};
const getOperatorByName = operator => operators[operator];
const getDescription = operator => /*#__PURE__*/_react.default.createElement("p", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 160,
    columnNumber: 46
  }
}, getOperatorByName(operator).description);
const setupGetOperatorSuggestions = () => {
  return ({
    indexPatterns
  }, {
    end,
    fieldName,
    nestedPath
  }) => {
    const allFields = (0, _lodash.flatten)(indexPatterns.map(indexPattern => {
      return indexPattern.fields.slice();
    }));
    const fullFieldName = nestedPath ? `${nestedPath}.${fieldName}` : fieldName;
    const fields = allFields.filter(field => field.name === fullFieldName).map(field => {
      const matchingOperators = Object.keys(operators).filter(operator => {
        const {
          fieldTypes
        } = getOperatorByName(operator);
        return !fieldTypes || fieldTypes.includes(field.type);
      });
      const suggestions = matchingOperators.map(operator => ({
        type: _query_suggestion_provider.QuerySuggestionTypes.Operator,
        text: operator + ' ',
        description: getDescription(operator),
        start: end,
        end
      }));
      return suggestions;
    });
    return Promise.resolve((0, _lodash.flatten)(fields));
  };
};
exports.setupGetOperatorSuggestions = setupGetOperatorSuggestions;