"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupGetConjunctionSuggestions = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _query_suggestion_provider = require("../query_suggestion_provider");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_search/public/autocomplete/providers/kql_query_suggestion/conjunction.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const bothArgumentsText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "unifiedSearch.kueryAutocomplete.andOperatorDescription.bothArgumentsText",
  defaultMessage: "both arguments",
  description: "Part of unifiedSearch.kueryAutocomplete.andOperatorDescription. Full text: 'Requires both arguments to be true'",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 18,
    columnNumber: 3
  }
});
const oneOrMoreArgumentsText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "unifiedSearch.kueryAutocomplete.orOperatorDescription.oneOrMoreArgumentsText",
  defaultMessage: "one or more arguments",
  description: "Part of unifiedSearch.kueryAutocomplete.orOperatorDescription. Full text: 'Requires one or more arguments to be true'",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 26,
    columnNumber: 3
  }
});
const conjunctions = {
  and: /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "unifiedSearch.kueryAutocomplete.andOperatorDescription",
    defaultMessage: "Requires {bothArguments} to be true",
    values: {
      bothArguments: /*#__PURE__*/_react.default.createElement("span", {
        className: "kbnSuggestionItem__callout",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 40,
          columnNumber: 26
        }
      }, bothArgumentsText)
    },
    description: "Full text: ' Requires both arguments to be true'. See 'unifiedSearch.kueryAutocomplete.andOperatorDescription.bothArgumentsText' for 'both arguments' part.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 7
    }
  })),
  or: /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "unifiedSearch.kueryAutocomplete.orOperatorDescription",
    defaultMessage: "Requires {oneOrMoreArguments} to be true",
    values: {
      oneOrMoreArguments: /*#__PURE__*/_react.default.createElement("span", {
        className: "kbnSuggestionItem__callout",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 54,
          columnNumber: 13
        }
      }, oneOrMoreArgumentsText)
    },
    description: "Full text: 'Requires one or more arguments to be true'. See 'unifiedSearch.kueryAutocomplete.orOperatorDescription.oneOrMoreArgumentsText' for 'one or more arguments' part.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }))
};
const setupGetConjunctionSuggestions = core => {
  return (querySuggestionsArgs, {
    text,
    end
  }) => {
    let suggestions = [];
    if (text.endsWith(' ')) {
      suggestions = Object.keys(conjunctions).map(key => ({
        type: _query_suggestion_provider.QuerySuggestionTypes.Conjunction,
        text: `${key} `,
        description: conjunctions[key],
        start: end,
        end
      }));
    }
    return Promise.resolve(suggestions);
  };
};
exports.setupGetConjunctionSuggestions = setupGetConjunctionSuggestions;