"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Overview = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _apmTypes = require("@kbn/apm-types");
var _discoverUtils = require("@kbn/discover-utils");
var _react2 = _interopRequireWildcard(require("react"));
var _get_height = require("../../../doc_viewer_source/get_height");
var _about = require("../components/about");
var _errors = require("../components/errors");
var _similar_spans = require("../components/similar_spans");
var _span_links = require("../components/span_links");
var _trace_context_log_events = require("../components/trace_context_log_events");
var _trace_waterfall = require("../components/trace_waterfall");
var _helpers = require("../helpers");
var _use_data_sources = require("../hooks/use_data_sources");
var _use_fetch_trace_root_item = require("./hooks/use_fetch_trace_root_item");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_doc_viewer/public/components/observability/traces/doc_viewer_overview/overview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Overview = exports.Overview = /*#__PURE__*/(0, _react2.forwardRef)(({
  hit,
  filter,
  onAddColumn,
  onRemoveColumn,
  indexes,
  showWaterfall = true,
  dataView,
  decreaseAvailableHeightBy = _get_height.DEFAULT_MARGIN_BOTTOM
}, ref) => {
  var _flattenedHit$TRANSAC;
  const [containerRef, setContainerRef] = (0, _react2.useState)(null);
  const flattenedHit = (0, _react2.useMemo)(() => (0, _discoverUtils.getFlattenedTraceDocumentOverview)(hit), [hit]);
  const [errorsTableSectionRef, setErrorsTableSectionRef] = (0, _react2.useState)(null);
  const isSpan = !(0, _helpers.isTransaction)(hit);
  const apmDurationField = (_flattenedHit$TRANSAC = flattenedHit[_apmTypes.TRANSACTION_DURATION]) !== null && _flattenedHit$TRANSAC !== void 0 ? _flattenedHit$TRANSAC : flattenedHit[_apmTypes.SPAN_DURATION];
  const isOtelSpan = apmDurationField == null && flattenedHit[_apmTypes.DURATION] != null;
  const duration = apmDurationField !== null && apmDurationField !== void 0 ? apmDurationField : flattenedHit[_apmTypes.DURATION] * 0.001;
  const traceId = flattenedHit[_apmTypes.TRACE_ID];
  const transactionId = flattenedHit[_apmTypes.TRANSACTION_ID];
  const spanId = flattenedHit[_apmTypes.SPAN_ID];
  const serviceName = flattenedHit[_apmTypes.SERVICE_NAME];
  const docId = isSpan ? spanId : transactionId;
  const containerHeight = containerRef ? (0, _get_height.getTabContentAvailableHeight)(containerRef, decreaseAvailableHeightBy) : 0;
  (0, _react2.useImperativeHandle)(ref, () => ({
    openAndScrollToSection: section => {
      switch (section) {
        case 'errors-table':
          errorsTableSectionRef === null || errorsTableSectionRef === void 0 ? void 0 : errorsTableSectionRef.openAndScrollToSection();
          break;
        default:
          break;
      }
    }
  }), [errorsTableSectionRef]);
  return /*#__PURE__*/_react2.default.createElement(_use_data_sources.DataSourcesProvider, {
    indexes: indexes,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_use_fetch_trace_root_item.TraceRootItemProvider, {
    traceId: traceId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement("div", {
    ref: setContainerRef,
    css: containerHeight ? (0, _react.css)`
                    max-height: ${containerHeight}px;
                    overflow: auto;
                  ` : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react2.default.createElement(_about.About, {
    hit: hit,
    dataView: dataView,
    filter: filter,
    onAddColumn: onAddColumn,
    onRemoveColumn: onRemoveColumn,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react2.default.createElement(_similar_spans.SimilarSpans, {
    spanName: flattenedHit[_apmTypes.SPAN_NAME],
    serviceName: serviceName,
    transactionName: flattenedHit[_apmTypes.TRANSACTION_NAME],
    transactionType: flattenedHit[_apmTypes.TRANSACTION_TYPE],
    isOtelSpan: isOtelSpan,
    duration: duration || 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 13
    }
  }), showWaterfall ? /*#__PURE__*/_react2.default.createElement(_trace_waterfall.TraceWaterfall, {
    dataView: dataView,
    traceId: traceId,
    serviceName: serviceName,
    docId: docId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 15
    }
  }) : null, /*#__PURE__*/_react2.default.createElement(_errors.ErrorsTable, {
    ref: setErrorsTableSectionRef,
    traceId: traceId,
    docId: docId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react2.default.createElement(_trace_context_log_events.TraceContextLogEvents, {
    traceId: traceId,
    spanId: spanId,
    transactionId: transactionId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 13
    }
  }), docId ? /*#__PURE__*/_react2.default.createElement(_span_links.SpanLinks, {
    traceId: traceId,
    docId: docId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 22
    }
  }) : null)));
});