"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchTraceRootItemContext = exports.TraceRootItemProvider = void 0;
var _constate = _interopRequireDefault(require("constate"));
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _apmTypes = require("@kbn/apm-types");
var _rxjs = require("rxjs");
var _plugin = require("../../../../../plugin");
var _use_data_sources = require("../../hooks/use_data_sources");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function getTraceRootItem({
  data,
  signal,
  traceId,
  indexPattern
}) {
  return (0, _rxjs.lastValueFrom)(data.search.search({
    params: {
      index: indexPattern,
      size: 1,
      body: {
        timeout: '20s',
        fields: [_apmTypes.TRANSACTION_DURATION, _apmTypes.SPAN_DURATION, _apmTypes.DURATION],
        query: {
          bool: {
            should: [{
              constant_score: {
                filter: {
                  bool: {
                    must_not: {
                      exists: {
                        field: _apmTypes.PARENT_ID
                      }
                    }
                  }
                }
              }
            }],
            filter: [{
              term: {
                [_apmTypes.TRACE_ID]: traceId
              }
            }]
          }
        }
      }
    }
  }, {
    abortSignal: signal
  }));
}
const useFetchTraceRootItem = ({
  traceId
}) => {
  const {
    indexes
  } = (0, _use_data_sources.useDataSourcesContext)();
  const indexPattern = indexes.apm.traces;
  const {
    core,
    data
  } = (0, _plugin.getUnifiedDocViewerServices)();
  const [item, setItem] = (0, _react.useState)(null);
  const [loading, setLoading] = (0, _react.useState)(true);
  (0, _react.useEffect)(() => {
    if (!traceId) {
      setItem(null);
      setLoading(false);
      return;
    }
    const controller = new AbortController();
    const {
      signal
    } = controller;
    const fetchData = async () => {
      try {
        var _result$rawResponse$h, _ref, _fields$TRANSACTION_D;
        setLoading(true);
        const result = indexPattern ? await getTraceRootItem({
          data,
          signal,
          traceId,
          indexPattern
        }) : undefined;
        const fields = result === null || result === void 0 ? void 0 : (_result$rawResponse$h = result.rawResponse.hits.hits[0]) === null || _result$rawResponse$h === void 0 ? void 0 : _result$rawResponse$h.fields;
        const itemDuration = (_ref = (_fields$TRANSACTION_D = fields === null || fields === void 0 ? void 0 : fields[_apmTypes.TRANSACTION_DURATION]) !== null && _fields$TRANSACTION_D !== void 0 ? _fields$TRANSACTION_D : fields === null || fields === void 0 ? void 0 : fields[_apmTypes.SPAN_DURATION]) !== null && _ref !== void 0 ? _ref : (fields === null || fields === void 0 ? void 0 : fields[_apmTypes.DURATION]) * 0.001;
        setItem({
          duration: itemDuration
        });
      } catch (err) {
        if (!signal.aborted) {
          const error = err;
          core.notifications.toasts.addDanger({
            title: _i18n.i18n.translate('unifiedDocViewer.docViewerTraceOverview.useFetchTraceRootItem.error', {
              defaultMessage: 'An error occurred while fetching the root item of the trace'
            }),
            text: error.message
          });
          setItem(null);
        }
      } finally {
        setLoading(false);
      }
    };
    fetchData();
    return function onUnmount() {
      controller.abort();
    };
  }, [data, core.notifications.toasts, traceId, indexPattern]);
  return {
    loading,
    item
  };
};
const [TraceRootItemProvider, useFetchTraceRootItemContext] = (0, _constate.default)(useFetchTraceRootItem);
exports.useFetchTraceRootItemContext = useFetchTraceRootItemContext;
exports.TraceRootItemProvider = TraceRootItemProvider;