"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchSpanLinks = useFetchSpanLinks;
var _reactHooks = require("@kbn/react-hooks");
var _plugin = require("../../../../../plugin");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const INITIAL_VALUE = {
  incomingSpanLinks: [],
  outgoingSpanLinks: []
};
function useFetchSpanLinks({
  docId,
  traceId,
  processorEvent
}) {
  const {
    discoverShared,
    data
  } = (0, _plugin.getUnifiedDocViewerServices)();
  const timeFilter = data.query.timefilter.timefilter.getAbsoluteTime();
  const fetchSpanLinks = discoverShared.features.registry.getById('observability-traces-fetch-span-links');
  const {
    loading,
    error,
    value
  } = (0, _reactHooks.useAbortableAsync)(async ({
    signal
  }) => {
    if (!fetchSpanLinks) {
      return null;
    }
    return fetchSpanLinks.fetchSpanLinks({
      docId,
      traceId,
      start: timeFilter.from,
      end: timeFilter.to,
      processorEvent
    }, signal);
  }, [fetchSpanLinks]);
  return {
    loading,
    error,
    value: value || INITIAL_VALUE
  };
}