"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEsqlQuery = getEsqlQuery;
var _apmTypes = require("@kbn/apm-types");
var _esqlComposer = require("@kbn/esql-composer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getEsqlQuery({
  serviceName,
  spanName,
  transactionName,
  transactionType
}) {
  if (transactionType && serviceName && transactionName) {
    return getSimilarTransactionsESQL({
      serviceName,
      transactionName,
      transactionType
    });
  }
  if (serviceName && spanName) {
    return getSimilarSpansESQL({
      serviceName,
      spanName
    });
  }
  return undefined;
}
function getSimilarSpansESQL({
  serviceName,
  spanName
}) {
  return (0, _esqlComposer.where)(`${_apmTypes.SERVICE_NAME} == ?serviceName AND ${_apmTypes.SPAN_NAME} == ?spanName`, {
    serviceName,
    spanName
  });
}
function getSimilarTransactionsESQL({
  serviceName,
  transactionName,
  transactionType
}) {
  return (0, _esqlComposer.where)(`${_apmTypes.SERVICE_NAME} == ?serviceName AND ${_apmTypes.TRANSACTION_NAME} == ?transactionName AND ${_apmTypes.TRANSACTION_TYPE} == ?transactionType`, {
    serviceName,
    transactionName,
    transactionType
  });
}