"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.spanFlyoutId = exports.SpanFlyout = void 0;
var _i18n = require("@kbn/i18n");
var _objectUtils = require("@kbn/object-utils");
var _react = _interopRequireWildcard(require("react"));
var _ = require("..");
var _overview = require("../../../../doc_viewer_overview/overview");
var _use_data_sources = require("../../../../hooks/use_data_sources");
var _is_span = require("../../helpers/is_span");
var _use_span = require("../../hooks/use_span");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_doc_viewer/public/components/observability/traces/components/full_screen_waterfall/waterfall_flyout/span_flyout/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const spanFlyoutId = exports.spanFlyoutId = 'spanDetailFlyout';
const SpanFlyout = ({
  spanId,
  traceId,
  dataView,
  onCloseFlyout,
  activeSection
}) => {
  const {
    span,
    docId,
    loading
  } = (0, _use_span.useSpan)({
    spanId,
    traceId
  });
  const {
    indexes
  } = (0, _use_data_sources.useDataSourcesContext)();
  const [flyoutRef, setFlyoutRef] = (0, _react.useState)(null);
  const documentAsHit = (0, _react.useMemo)(() => {
    if (!span || !docId) return null;
    return {
      id: docId,
      raw: {
        _index: span._index,
        _id: docId,
        _source: span
      },
      flattened: (0, _objectUtils.flattenObject)(span)
    };
  }, [docId, span]);
  const isSpan = (0, _is_span.isSpanHit)(documentAsHit);
  (0, _react.useEffect)(() => {
    if (activeSection && flyoutRef) {
      flyoutRef.openAndScrollToSection(activeSection);
    }
  }, [activeSection, flyoutRef]);
  return /*#__PURE__*/_react.default.createElement(_.WaterfallFlyout, {
    flyoutId: spanFlyoutId,
    onCloseFlyout: onCloseFlyout,
    dataView: dataView,
    hit: documentAsHit,
    loading: loading,
    title: _i18n.i18n.translate('unifiedDocViewer.observability.traces.fullScreenWaterfall.spanFlyout.title', {
      defaultMessage: '{docType} document',
      values: {
        docType: isSpan ? _i18n.i18n.translate('unifiedDocViewer.observability.traces.fullScreenWaterfall.spanFlyout.title.span', {
          defaultMessage: 'Span'
        }) : _i18n.i18n.translate('unifiedDocViewer.observability.traces.fullScreenWaterfall.spanFlyout.title.transction', {
          defaultMessage: 'Transaction'
        })
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 5
    }
  }, documentAsHit ? /*#__PURE__*/_react.default.createElement(_overview.Overview, {
    ref: setFlyoutRef,
    hit: documentAsHit,
    indexes: indexes,
    showWaterfall: false,
    showActions: false,
    dataView: dataView,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 9
    }
  }) : null);
};
exports.SpanFlyout = SpanFlyout;