"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaterfallFlyout = WaterfallFlyout;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _doc_viewer_source = _interopRequireDefault(require("../../../../../doc_viewer_source"));
var _doc_viewer_table = _interopRequireDefault(require("../../../../../doc_viewer_table"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_doc_viewer/public/components/observability/traces/components/full_screen_waterfall/waterfall_flyout/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const tabIds = {
  OVERVIEW: 'unifiedDocViewerTracesSpanFlyoutOverview',
  TABLE: 'unifiedDocViewerTracesSpanFlyoutTable',
  JSON: 'unifiedDocViewerTracesSpanFlyoutJson'
};
const tabs = [{
  id: tabIds.OVERVIEW,
  name: _i18n.i18n.translate('unifiedDocViewer.observability.traces.fullScreenWaterfall.tabs.overview', {
    defaultMessage: 'Overview'
  })
}, {
  id: tabIds.TABLE,
  name: _i18n.i18n.translate('unifiedDocViewer.observability.traces.fullScreenWaterfall.tabs.table', {
    defaultMessage: 'Table'
  })
}, {
  id: tabIds.JSON,
  name: _i18n.i18n.translate('unifiedDocViewer.observability.traces.fullScreenWaterfall.tabs.json', {
    defaultMessage: 'JSON'
  })
}];
const FlyoutTabs = ({
  onClick,
  selectedTabId
}) => {
  return tabs.map(tab => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    key: tab.id,
    onClick: () => onClick(tab.id),
    isSelected: tab.id === selectedTabId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 5
    }
  }, tab.name));
};
function WaterfallFlyout({
  onCloseFlyout,
  dataView,
  hit,
  loading,
  children,
  title,
  flyoutId
}) {
  const [selectedTabId, setSelectedTabId] = (0, _react.useState)(tabIds.OVERVIEW);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    includeFixedHeadersInFocusTrap: false,
    ownFocus: false,
    css: {
      zIndex: euiTheme.levels.mask + 1,
      top: '0'
    },
    onClose: onCloseFlyout,
    "aria-labelledby": flyoutId,
    id: flyoutId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonTitle, {
    isLoading: loading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 13
    }
  }, title)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 7
    }
  }, loading || !hit ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 5,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(FlyoutTabs, {
    onClick: setSelectedTabId,
    selectedTabId: selectedTabId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    isLoading: loading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 13
    }
  }, selectedTabId === tabIds.OVERVIEW && hit ? /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 17
    }
  }, children) : null, selectedTabId === tabIds.TABLE && hit ? /*#__PURE__*/_react.default.createElement(_doc_viewer_table.default, {
    hit: hit,
    dataView: dataView,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 17
    }
  }) : null, selectedTabId === tabIds.JSON && hit ? /*#__PURE__*/_react.default.createElement(_doc_viewer_source.default, {
    id: hit.id,
    index: hit.raw._index,
    dataView: dataView,
    esqlHit: hit,
    onRefresh: () => {},
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 17
    }
  }) : null))));
}