"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchLog = useFetchLog;
var _rxjs = require("rxjs");
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _use_data_sources = require("../../../../hooks/use_data_sources");
var _plugin = require("../../../../../../../plugin");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function fetchLogDocument({
  id,
  indexPattern,
  data,
  signal
}) {
  return (0, _rxjs.lastValueFrom)(data.search.search({
    params: {
      index: indexPattern,
      size: 1,
      body: {
        timeout: '20s',
        fields: [{
          field: '*',
          include_unmapped: true
        }],
        query: {
          term: {
            _id: id
          }
        }
      }
    }
  }, {
    abortSignal: signal
  }));
}
function useFetchLog({
  id
}) {
  const {
    indexes
  } = (0, _use_data_sources.useDataSourcesContext)();
  const {
    data,
    core
  } = (0, _plugin.getUnifiedDocViewerServices)();
  const [loading, setLoading] = (0, _react.useState)(true);
  const [logDoc, setLogDoc] = (0, _react.useState)(null);
  const [index, setIndex] = (0, _react.useState)(null);
  const indexPattern = indexes.logs;
  (0, _react.useEffect)(() => {
    const controller = new AbortController();
    const {
      signal
    } = controller;
    const fetchData = async () => {
      try {
        var _result$rawResponse$h, _result$rawResponse$h2, _result$rawResponse$h3, _result$rawResponse$h4;
        setLoading(true);
        const result = indexPattern ? await fetchLogDocument({
          id,
          indexPattern,
          data,
          signal
        }) : undefined;
        setIndex((_result$rawResponse$h = result === null || result === void 0 ? void 0 : (_result$rawResponse$h2 = result.rawResponse.hits.hits[0]) === null || _result$rawResponse$h2 === void 0 ? void 0 : _result$rawResponse$h2._index) !== null && _result$rawResponse$h !== void 0 ? _result$rawResponse$h : null);
        setLogDoc((_result$rawResponse$h3 = result === null || result === void 0 ? void 0 : (_result$rawResponse$h4 = result.rawResponse.hits.hits[0]) === null || _result$rawResponse$h4 === void 0 ? void 0 : _result$rawResponse$h4.fields) !== null && _result$rawResponse$h3 !== void 0 ? _result$rawResponse$h3 : null);
      } catch (err) {
        if (!signal.aborted) {
          const error = err;
          core.notifications.toasts.addDanger({
            title: _i18n.i18n.translate('unifiedDocViewer.fullScreenWaterfall.logDocument.error', {
              defaultMessage: 'An error occurred while fetching the log document'
            }),
            text: error.message
          });
          setLogDoc(null);
        }
      } finally {
        setLoading(false);
      }
    };
    fetchData();
    return function onUnmount() {
      controller.abort();
    };
  }, [core.notifications.toasts, data, id, indexPattern]);
  return {
    loading,
    logDoc,
    index
  };
}