"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTransactionFieldConfigurations = exports.getSpanFieldConfigurations = exports.getSharedFieldConfigurations = void 0;
var _react = _interopRequireDefault(require("react"));
var _apmTypes = require("@kbn/apm-types");
var _apmUiShared = require("@kbn/apm-ui-shared");
var _eui = require("@elastic/eui");
var _service_name_link = require("../service_name_link");
var _transaction_name_link = require("../transaction_name_link");
var _highlight_field = require("../highlight_field");
var _dependency_name_link = require("../dependency_name_link");
var _trace_id_link = require("../trace_id_link");
var _constants = require("../../../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_doc_viewer/public/components/observability/traces/components/about/field_configurations.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const getSharedFieldConfigurations = flattenedHit => {
  return {
    [_apmTypes.SERVICE_NAME]: {
      title: _constants.fieldLabels.SERVICE_NAME_LABEL,
      formatter: (value, formattedValue) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
        value: value,
        formattedValue: formattedValue,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 49,
          columnNumber: 11
        }
      }, ({
        content
      }) => {
        var _flattenedHit$AGENT_N;
        return /*#__PURE__*/_react.default.createElement(_service_name_link.ServiceNameLink, {
          serviceName: value,
          agentName: (_flattenedHit$AGENT_N = flattenedHit[_apmTypes.AGENT_NAME]) !== null && _flattenedHit$AGENT_N !== void 0 ? _flattenedHit$AGENT_N : '',
          formattedServiceName: content,
          "data-test-subj": "unifiedDocViewerObservabilityTracesServiceNameLink",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 51,
            columnNumber: 15
          }
        });
      }))
    },
    [_apmTypes.AT_TIMESTAMP]: {
      title: _constants.fieldLabels.AT_TIMESTAMP_LABEL,
      formatter: value => /*#__PURE__*/_react.default.createElement(_apmUiShared.Timestamp, {
        timestamp: value,
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 64,
          columnNumber: 38
        }
      })
    },
    [_apmTypes.HTTP_RESPONSE_STATUS_CODE]: {
      title: _constants.fieldLabels.HTTP_RESPONSE_STATUS_CODE_LABEL,
      formatter: value => /*#__PURE__*/_react.default.createElement(_apmUiShared.HttpStatusCode, {
        code: value,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 68,
          columnNumber: 38
        }
      })
    },
    [_apmTypes.TRANSACTION_ID]: {
      title: _constants.fieldLabels.TRANSACTION_ID_LABEL
    },
    [_apmTypes.TRACE_ID]: {
      title: _constants.fieldLabels.TRACE_ID_LABEL,
      formatter: (value, formattedValue) => /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
        value: value,
        formattedValue: formattedValue,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 76,
          columnNumber: 9
        }
      }, ({
        content
      }) => /*#__PURE__*/_react.default.createElement(_trace_id_link.TraceIdLink, {
        traceId: value,
        formattedTraceId: content,
        "data-test-subj": "unifiedDocViewerObservabilityTracesTraceIdLink",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 78,
          columnNumber: 13
        }
      }))
    }
  };
};
exports.getSharedFieldConfigurations = getSharedFieldConfigurations;
const getSpanFieldConfigurations = flattenedHit => {
  return {
    [_apmTypes.SPAN_ID]: {
      title: _constants.fieldLabels.SPAN_ID_LABEL
    },
    [_apmTypes.SPAN_NAME]: {
      title: _constants.fieldLabels.SPAN_NAME_LABEL
    },
    [_apmTypes.SPAN_DESTINATION_SERVICE_RESOURCE]: {
      title: _constants.fieldLabels.SPAN_DESTINATION_SERVICE_RESOURCE_LABEL,
      formatter: (value, formattedValue) => /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
        value: value,
        formattedValue: formattedValue,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 103,
          columnNumber: 9
        }
      }, ({
        content
      }) => {
        var _flattenedHit$SPAN_TY, _flattenedHit$SPAN_SU, _flattenedHit$SERVICE;
        return /*#__PURE__*/_react.default.createElement(_dependency_name_link.DependencyNameLink, {
          dependencyName: value,
          spanType: (_flattenedHit$SPAN_TY = flattenedHit[_apmTypes.SPAN_TYPE]) !== null && _flattenedHit$SPAN_TY !== void 0 ? _flattenedHit$SPAN_TY : '',
          spanSubtype: (_flattenedHit$SPAN_SU = flattenedHit[_apmTypes.SPAN_SUBTYPE]) !== null && _flattenedHit$SPAN_SU !== void 0 ? _flattenedHit$SPAN_SU : '',
          environment: (_flattenedHit$SERVICE = flattenedHit[_apmTypes.SERVICE_ENVIRONMENT]) !== null && _flattenedHit$SERVICE !== void 0 ? _flattenedHit$SERVICE : '',
          formattedDependencyName: content,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 105,
            columnNumber: 13
          }
        });
      }),
      description: _constants.fieldDescriptions.SPAN_DESTINATION_SERVICE_RESOURCE_DESCRIPTION
    },
    [_apmTypes.SPAN_DURATION]: {
      title: _constants.fieldLabels.SPAN_DURATION_LABEL
    },
    [_apmTypes.SPAN_TYPE]: {
      title: _constants.fieldLabels.SPAN_TYPE_LABEL,
      formatter: (value, formattedValue) => /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
        value: value,
        formattedValue: formattedValue,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 123,
          columnNumber: 9
        }
      }, ({
        content
      }) => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 124,
          columnNumber: 29
        }
      }, content))
    },
    [_apmTypes.SPAN_SUBTYPE]: {
      title: _constants.fieldLabels.SPAN_SUBTYPE_LABEL,
      formatter: (value, formattedValue) => /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
        value: value,
        formattedValue: formattedValue,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 131,
          columnNumber: 9
        }
      }, ({
        content
      }) => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 132,
          columnNumber: 29
        }
      }, content))
    }
  };
};
exports.getSpanFieldConfigurations = getSpanFieldConfigurations;
const getTransactionFieldConfigurations = flattenedHit => {
  return {
    [_apmTypes.TRANSACTION_NAME]: {
      title: _constants.fieldLabels.TRANSACTION_NAME_LABEL,
      formatter: (value, formattedValue) => /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
        value: value,
        formattedValue: formattedValue,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 146,
          columnNumber: 9
        }
      }, ({
        content
      }) => {
        var _flattenedHit$SERVICE2;
        return /*#__PURE__*/_react.default.createElement(_transaction_name_link.TransactionNameLink, {
          serviceName: (_flattenedHit$SERVICE2 = flattenedHit[_apmTypes.SERVICE_NAME]) !== null && _flattenedHit$SERVICE2 !== void 0 ? _flattenedHit$SERVICE2 : '',
          transactionName: value,
          renderContent: () => content,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 148,
            columnNumber: 13
          }
        });
      })
    },
    [_apmTypes.TRANSACTION_DURATION]: {
      title: _constants.fieldLabels.TRANSACTION_DURATION_LABEL
    },
    [_apmTypes.USER_AGENT_NAME]: {
      title: _constants.fieldLabels.USER_AGENT_NAME_LABEL
    },
    [_apmTypes.USER_AGENT_VERSION]: {
      title: _constants.fieldLabels.USER_AGENT_VERSION_LABEL
    }
  };
};
exports.getTransactionFieldConfigurations = getTransactionFieldConfigurations;