"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Overview = Overview;
var _eui = require("@elastic/eui");
var _discoverUtils = require("@kbn/discover-utils");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _apmTypes = require("@kbn/apm-types");
var _use_data_sources = require("../../traces/hooks/use_data_sources");
var _get_height = require("../../../doc_viewer_source/get_height");
var _about = require("../../traces/components/about");
var _use_fetch_trace_root_item = require("../../traces/doc_viewer_overview/hooks/use_fetch_trace_root_item");
var _trace_waterfall = require("../../traces/components/trace_waterfall");
var _errors = require("../../traces/components/errors");
var _trace_context_log_events = require("../../traces/components/trace_context_log_events");
var _helpers = require("../../traces/helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_doc_viewer/public/components/observability/generic/doc_viewer_overview/overview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function Overview({
  hit,
  filter,
  onAddColumn,
  onRemoveColumn,
  indexes,
  showWaterfall = true,
  dataView,
  decreaseAvailableHeightBy = _get_height.DEFAULT_MARGIN_BOTTOM
}) {
  const [containerRef, setContainerRef] = (0, _react.useState)(null);
  const flattenedHit = (0, _react.useMemo)(() => (0, _discoverUtils.getFlattenedTraceDocumentOverview)(hit), [hit]);
  const isSpan = !(0, _helpers.isTransaction)(hit);
  const traceId = flattenedHit[_apmTypes.TRACE_ID];
  const transactionId = flattenedHit[_apmTypes.TRANSACTION_ID];
  const spanId = flattenedHit[_apmTypes.SPAN_ID];
  const serviceName = flattenedHit[_apmTypes.SERVICE_NAME];
  const docId = isSpan ? spanId : transactionId;
  const containerHeight = containerRef ? (0, _get_height.getTabContentAvailableHeight)(containerRef, decreaseAvailableHeightBy) : 0;
  return /*#__PURE__*/_react.default.createElement(_use_data_sources.DataSourcesProvider, {
    indexes: indexes,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_use_fetch_trace_root_item.TraceRootItemProvider, {
    traceId: traceId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    ref: setContainerRef,
    css: containerHeight ? (0, _react2.css)`
                  max-height: ${containerHeight}px;
                  overflow: auto;
                ` : undefined,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_about.About, {
    hit: hit,
    dataView: dataView,
    filter: filter,
    onAddColumn: onAddColumn,
    onRemoveColumn: onRemoveColumn,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 11
    }
  }), showWaterfall ? /*#__PURE__*/_react.default.createElement(_trace_waterfall.TraceWaterfall, {
    dataView: dataView,
    traceId: traceId,
    docId: docId,
    serviceName: serviceName,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 13
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_errors.ErrorsTable, {
    traceId: traceId,
    docId: docId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_trace_context_log_events.TraceContextLogEvents, {
    traceId: traceId,
    spanId: spanId,
    transactionId: transactionId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 11
    }
  }))));
}