"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AttributesTable = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _plugin = require("../../../../plugin");
var _field_row = require("../../../doc_viewer_table/field_row");
var _table_cell = require("../../../doc_viewer_table/table_cell");
var _table_cell_actions = require("../../../doc_viewer_table/table_cell_actions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_doc_viewer/public/components/observability/attributes/doc_viewer_attributes_overview/attributes_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AttributesTable = ({
  hit,
  dataView,
  columnsMeta,
  fields,
  searchTerm,
  columns,
  filter,
  onAddColumn,
  onRemoveColumn,
  isEsqlMode
}) => {
  const flattened = hit.flattened;
  const {
    fieldFormats,
    toasts
  } = (0, _plugin.getUnifiedDocViewerServices)();
  const onToggleColumn = (0, _react.useMemo)(() => {
    if (!onRemoveColumn || !onAddColumn || !columns) {
      return undefined;
    }
    return field => {
      if (columns.includes(field)) {
        onRemoveColumn(field);
      } else {
        onAddColumn(field);
      }
    };
  }, [onRemoveColumn, onAddColumn, columns]);
  const rows = (0, _react.useMemo)(() => fields.map(field => new _field_row.FieldRow({
    name: field.name,
    displayNameOverride: field.displayName,
    flattenedValue: flattened[field.name],
    hit,
    dataView,
    fieldFormats,
    isPinned: false,
    columnsMeta
  })), [fields, flattened, hit, dataView, fieldFormats, columnsMeta]);
  const fieldCellActions = (0, _react.useMemo)(() => (0, _table_cell_actions.getFieldCellActions)({
    rows,
    isEsqlMode,
    onFilter: filter,
    onToggleColumn
  }), [rows, filter, onToggleColumn, isEsqlMode]);
  const fieldValueCellActions = (0, _react.useMemo)(() => (0, _table_cell_actions.getFieldValueCellActions)({
    rows,
    isEsqlMode,
    toasts,
    onFilter: filter
  }), [rows, toasts, filter, isEsqlMode]);
  const gridColumns = [{
    id: 'name',
    displayAsText: _i18n.i18n.translate('unifiedDocViewer.docView.attributes.table.nameColumn', {
      defaultMessage: 'Field'
    }),
    actions: false,
    visibleCellActions: 3,
    cellActions: fieldCellActions
  }, {
    id: 'value',
    displayAsText: _i18n.i18n.translate('unifiedDocViewer.docView.attributes.table.valueColumn', {
      defaultMessage: 'Value'
    }),
    actions: false,
    visibleCellActions: 3,
    cellActions: fieldValueCellActions
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDataGrid, {
    "aria-label": _i18n.i18n.translate('unifiedDocViewer.docView.attributes.table.ariaLabel', {
      defaultMessage: 'Attributes table'
    }),
    columns: gridColumns,
    rowCount: rows.length,
    renderCellValue: ({
      rowIndex,
      columnId
    }) => /*#__PURE__*/_react.default.createElement(_table_cell.TableCell, {
      searchTerm: searchTerm,
      rows: rows,
      rowIndex: rowIndex,
      columnId: columnId,
      isDetails: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 9
      }
    }),
    columnVisibility: {
      visibleColumns: ['name', 'value'],
      setVisibleColumns: () => null
    },
    gridStyle: {
      border: 'horizontal',
      stripes: true,
      rowHover: 'highlight',
      header: 'underline',
      cellPadding: 'm',
      fontSize: 's'
    },
    rowHeightsOptions: {
      defaultHeight: 'auto'
    },
    inMemory: {
      level: 'enhancements'
    },
    toolbarVisibility: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 5
    }
  });
};
exports.AttributesTable = AttributesTable;