"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPinColumnControl = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_doc_viewer/public/components/doc_viewer_table/get_pin_control.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const PinControlCell = /*#__PURE__*/_react.default.memo(({
  row,
  onTogglePinned
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const fieldName = row.name;
  const isPinned = row.isPinned;
  const label = isPinned ? _i18n.i18n.translate('unifiedDocViewer.docViews.table.unpinFieldLabel', {
    defaultMessage: 'Unpin field'
  }) : _i18n.i18n.translate('unifiedDocViewer.docViews.table.pinFieldLabel', {
    defaultMessage: 'Pin field'
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `unifiedDocViewer_pinControl_${fieldName}`,
    className: !isPinned ? 'kbnDocViewer__fieldsGrid__pinAction' : undefined,
    css: (0, _react2.css)`
        margin-left: ${isPinned ? '-1px' : 0}; // to align filled/unfilled pin icons better
        width: ${euiTheme.size.l};
        height: ${euiTheme.size.l};
        overflow: hidden;
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: label,
    delay: "long",
    disableScreenReaderOutput: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": `unifiedDocViewer_pinControlButton_${fieldName}`,
    iconSize: "m",
    iconType: isPinned ? 'pinFilled' : 'pin',
    color: "text",
    "aria-label": label,
    onClick: () => {
      onTogglePinned(fieldName);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 9
    }
  })));
});
const getPinColumnControl = ({
  rows,
  onTogglePinned
}) => {
  const pinColumnHeader = _i18n.i18n.translate('unifiedDocViewer.fieldsTable.pinControlColumnHeader', {
    defaultMessage: 'Pin field column'
  });
  return {
    id: 'pin_field',
    width: 32,
    headerCellRender: () => /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      "aria-label": pinColumnHeader,
      type: "info",
      content: pinColumnHeader,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 7
      }
    }),
    rowCellRender: ({
      rowIndex
    }) => {
      const row = rows[rowIndex];
      if (!row) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(PinControlCell, {
        key: `control-${row.name}`,
        row: row,
        onTogglePinned: onTogglePinned,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 85,
          columnNumber: 9
        }
      });
    }
  };
};
exports.getPinColumnControl = getPinColumnControl;