"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MIN_HEIGHT = exports.DocViewerSource = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _lodash = require("lodash");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _unifiedDocViewer = require("@kbn/unified-doc-viewer");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _hooks = require("../../hooks");
var _get_height = require("./get_height");
var _json_code_editor = require("../json_code_editor");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_doc_viewer/public/components/doc_viewer_source/source.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// Minimum height for the source content to guarantee minimum space when the flyout is scrollable.
const MIN_HEIGHT = exports.MIN_HEIGHT = 400;
const DocViewerSource = ({
  id,
  index,
  dataView,
  esqlHit,
  width,
  decreaseAvailableHeightBy,
  onRefresh
}) => {
  const styles = (0, _use_memo_css.useMemoCss)(componentStyles);
  const [editor, setEditor] = (0, _react.useState)();
  const [editorHeight, setEditorHeight] = (0, _react.useState)();
  const [jsonValue, setJsonValue] = (0, _react.useState)('');
  const [requestState, hit] = (0, _hooks.useEsDocSearch)({
    id,
    index,
    dataView,
    esqlHit
  });
  (0, _react.useEffect)(() => {
    if (requestState === _unifiedDocViewer.ElasticRequestState.Found && hit) {
      setJsonValue(JSON.stringify((0, _lodash.omit)(hit.raw, '_score'), undefined, 2));
    }
  }, [requestState, hit]);

  // setting editor height to fill the available space of the document flyout
  (0, _react.useEffect)(() => {
    if (!editor) {
      return;
    }
    const editorElement = editor.getDomNode();
    if (!editorElement) {
      return;
    }
    const height = (0, _get_height.getHeight)(editor, decreaseAvailableHeightBy !== null && decreaseAvailableHeightBy !== void 0 ? decreaseAvailableHeightBy : _get_height.DEFAULT_MARGIN_BOTTOM);
    if (height === 0) {
      return;
    }
    if (!jsonValue || jsonValue === '') {
      setEditorHeight(0);
    } else {
      setEditorHeight(height);
    }
  }, [editor, jsonValue, setEditorHeight, decreaseAvailableHeightBy]);
  const loadingState = /*#__PURE__*/_react.default.createElement("div", {
    css: styles.loading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    css: styles.loadingSpinner,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "unifiedDocViewer.loadingJSON",
    defaultMessage: "Loading JSON",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  })));
  const errorMessageTitle = /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('unifiedDocViewer.sourceViewer.errorMessageTitle', {
    defaultMessage: 'An Error Occurred'
  }));
  const errorMessage = /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('unifiedDocViewer.sourceViewer.errorMessage', {
    defaultMessage: 'Could not fetch data at this time. Refresh the tab to try again.'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "refresh",
    onClick: onRefresh,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('unifiedDocViewer.sourceViewer.refresh', {
    defaultMessage: 'Refresh'
  })));
  const errorState = /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "warning",
    title: errorMessageTitle,
    body: errorMessage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 5
    }
  });
  if (requestState === _unifiedDocViewer.ElasticRequestState.Error || requestState === _unifiedDocViewer.ElasticRequestState.NotFound) {
    return errorState;
  }
  if (requestState === _unifiedDocViewer.ElasticRequestState.Loading || jsonValue === '') {
    return loadingState;
  }
  return /*#__PURE__*/_react.default.createElement(_json_code_editor.JSONCodeEditorCommonMemoized, {
    jsonValue: jsonValue,
    width: width,
    height: editorHeight,
    hasLineNumbers: true,
    enableFindAction: true,
    onEditorDidMount: editorNode => setEditor(editorNode),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 5
    }
  });
};
exports.DocViewerSource = DocViewerSource;
const componentStyles = {
  loading: ({
    euiTheme
  }) => (0, _react2.css)({
    display: 'flex',
    flexDirection: 'row',
    justifyContent: 'left',
    flex: '1 0 100%',
    textAlign: 'center',
    height: '100%',
    width: '100%',
    marginTop: euiTheme.size.s
  }),
  loadingSpinner: ({
    euiTheme
  }) => (0, _react2.css)({
    marginRight: euiTheme.size.s
  })
};