"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.APM_ERROR_DATASTREAM_FIELDS = void 0;
exports.ApmStacktrace = ApmStacktrace;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eventStacktrace = require("@kbn/event-stacktrace");
var _unifiedDocViewer = require("@kbn/unified-doc-viewer");
var _hooks = require("../../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_doc_viewer/public/components/doc_viewer_logs_overview/sub_components/stacktrace/apm_stacktrace.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const APM_ERROR_DATASTREAM_FIELDS = exports.APM_ERROR_DATASTREAM_FIELDS = {
  dataStreamType: 'logs',
  dataStreamDataset: 'apm.error'
};
function ApmStacktrace({
  hit,
  dataView
}) {
  var _apmErrorDoc$service, _apmErrorDoc$service$, _apmErrorDoc$error, _apmErrorDoc$error2, _apmErrorDoc$error2$l, _apmErrorDoc$error3, _apmErrorDoc$error4, _apmErrorDoc$error4$l, _apmErrorDoc$error5, _apmErrorDoc$error5$e;
  const [apmErrorDoc, setApmErrorDoc] = (0, _react.useState)();
  const [requestState, esHit] = (0, _hooks.useEsDocSearch)({
    id: hit.raw._id || '',
    index: hit.raw._index,
    dataView
  });
  (0, _react.useEffect)(() => {
    if (requestState === _unifiedDocViewer.ElasticRequestState.Found && esHit) {
      setApmErrorDoc(esHit === null || esHit === void 0 ? void 0 : esHit.raw._source);
    }
  }, [requestState, esHit]);
  if (requestState === _unifiedDocViewer.ElasticRequestState.Loading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 12
      }
    });
  }
  if (requestState === _unifiedDocViewer.ElasticRequestState.Error || requestState === _unifiedDocViewer.ElasticRequestState.NotFound) {
    return /*#__PURE__*/_react.default.createElement("p", {
      "data-test-subj": "unifiedDocViewerApmStacktraceErrorMsg",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 7
      }
    }, _i18n.i18n.translate('unifiedDocViewer.apmStacktrace.errorMessage', {
      defaultMessage: 'Failed to load stacktrace'
    }));
  }
  const codeLanguage = apmErrorDoc === null || apmErrorDoc === void 0 ? void 0 : (_apmErrorDoc$service = apmErrorDoc.service) === null || _apmErrorDoc$service === void 0 ? void 0 : (_apmErrorDoc$service$ = _apmErrorDoc$service.language) === null || _apmErrorDoc$service$ === void 0 ? void 0 : _apmErrorDoc$service$.name;
  const exceptions = (apmErrorDoc === null || apmErrorDoc === void 0 ? void 0 : (_apmErrorDoc$error = apmErrorDoc.error) === null || _apmErrorDoc$error === void 0 ? void 0 : _apmErrorDoc$error.exception) || [];
  const logStackframes = apmErrorDoc === null || apmErrorDoc === void 0 ? void 0 : (_apmErrorDoc$error2 = apmErrorDoc.error) === null || _apmErrorDoc$error2 === void 0 ? void 0 : (_apmErrorDoc$error2$l = _apmErrorDoc$error2.log) === null || _apmErrorDoc$error2$l === void 0 ? void 0 : _apmErrorDoc$error2$l.stacktrace;
  const isPlaintextException = !!(apmErrorDoc !== null && apmErrorDoc !== void 0 && (_apmErrorDoc$error3 = apmErrorDoc.error) !== null && _apmErrorDoc$error3 !== void 0 && _apmErrorDoc$error3.stack_trace) && exceptions.length === 1 && !exceptions[0].stacktrace;
  if (apmErrorDoc !== null && apmErrorDoc !== void 0 && (_apmErrorDoc$error4 = apmErrorDoc.error) !== null && _apmErrorDoc$error4 !== void 0 && (_apmErrorDoc$error4$l = _apmErrorDoc$error4.log) !== null && _apmErrorDoc$error4$l !== void 0 && _apmErrorDoc$error4$l.message) {
    return /*#__PURE__*/_react.default.createElement(_eventStacktrace.Stacktrace, {
      stackframes: logStackframes,
      codeLanguage: codeLanguage,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 12
      }
    });
  }
  if (apmErrorDoc !== null && apmErrorDoc !== void 0 && (_apmErrorDoc$error5 = apmErrorDoc.error) !== null && _apmErrorDoc$error5 !== void 0 && (_apmErrorDoc$error5$e = _apmErrorDoc$error5.exception) !== null && _apmErrorDoc$error5$e !== void 0 && _apmErrorDoc$error5$e.length) {
    var _exceptions$;
    return isPlaintextException ? /*#__PURE__*/_react.default.createElement(_eventStacktrace.PlaintextStacktrace, {
      message: exceptions[0].message,
      type: (_exceptions$ = exceptions[0]) === null || _exceptions$ === void 0 ? void 0 : _exceptions$.type,
      stacktrace: apmErrorDoc === null || apmErrorDoc === void 0 ? void 0 : apmErrorDoc.error.stack_trace,
      codeLanguage: codeLanguage,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 7
      }
    }) : /*#__PURE__*/_react.default.createElement(_eventStacktrace.ExceptionStacktrace, {
      codeLanguage: codeLanguage,
      exceptions: exceptions,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 7
      }
    });
  }
  return null;
}