"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogsOverviewHighlights = LogsOverviewHighlights;
var _react = _interopRequireDefault(require("react"));
var _discoverUtils = require("@kbn/discover-utils");
var _eui = require("@elastic/eui");
var _content_framework = require("../content_framework");
var _highlight_field = require("../observability/traces/components/highlight_field");
var _trace_id_link = require("../observability/traces/components/trace_id_link");
var _constants = require("../observability/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_doc_viewer/public/components/doc_viewer_logs_overview/logs_overview_highlights.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function LogsOverviewHighlights({
  formattedDoc,
  hit,
  dataView,
  filter,
  onAddColumn,
  onRemoveColumn
}) {
  const flattenedDoc = hit.flattened;
  const shouldRenderSection = fields => {
    return fields.some(field => Boolean(formattedDoc[field] && flattenedDoc[field]));
  };
  if (!shouldRenderSection(fieldNames)) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false,
    paddingSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_content_framework.ContentFrameworkTable, {
    fieldNames: fieldNames,
    fieldConfigurations: fieldConfigurations,
    filter: filter,
    onAddColumn: onAddColumn,
    onRemoveColumn: onRemoveColumn,
    hit: hit,
    dataView: dataView,
    id: "logs-highlights",
    "data-test-subj": "unifiedDocViewLogsOverview",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 9
    }
  })));
}
const fieldNames = [
// Service & Infrastructure
_discoverUtils.fieldConstants.SERVICE_NAME_FIELD, _discoverUtils.fieldConstants.HOST_NAME_FIELD, _discoverUtils.fieldConstants.TRACE_ID_FIELD, _discoverUtils.fieldConstants.ORCHESTRATOR_CLUSTER_NAME_FIELD, _discoverUtils.fieldConstants.ORCHESTRATOR_RESOURCE_ID_FIELD,
// Cloud
_discoverUtils.fieldConstants.CLOUD_PROVIDER_FIELD, _discoverUtils.fieldConstants.CLOUD_REGION_FIELD, _discoverUtils.fieldConstants.CLOUD_AVAILABILITY_ZONE_FIELD, _discoverUtils.fieldConstants.CLOUD_PROJECT_ID_FIELD, _discoverUtils.fieldConstants.CLOUD_INSTANCE_ID_FIELD,
// Other
_discoverUtils.fieldConstants.LOG_FILE_PATH_FIELD, _discoverUtils.fieldConstants.DATASTREAM_DATASET_FIELD, _discoverUtils.fieldConstants.DATASTREAM_NAMESPACE_FIELD, _discoverUtils.fieldConstants.AGENT_NAME_FIELD];
const fieldConfigurations = {
  // Service & Infrastructure
  [_discoverUtils.fieldConstants.SERVICE_NAME_FIELD]: {
    title: _constants.fieldLabels.SERVICE_NAME_LABEL
  },
  [_discoverUtils.fieldConstants.HOST_NAME_FIELD]: {
    title: _constants.fieldLabels.HOST_NAME_LABEL
  },
  [_discoverUtils.fieldConstants.TRACE_ID_FIELD]: {
    title: _constants.fieldLabels.TRACE_ID_LABEL,
    formatter: (value, formattedValue) => /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
      value: value,
      formattedValue: formattedValue,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 7
      }
    }, ({
      content
    }) => /*#__PURE__*/_react.default.createElement(_trace_id_link.TraceIdLink, {
      traceId: value,
      formattedTraceId: content,
      "data-test-subj": "unifiedDocViewLogsOverviewTraceIdHighlightLink",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 11
      }
    }))
  },
  [_discoverUtils.fieldConstants.ORCHESTRATOR_CLUSTER_NAME_FIELD]: {
    title: _constants.fieldLabels.ORCHESTRATOR_CLUSTER_NAME_LABEL
  },
  [_discoverUtils.fieldConstants.ORCHESTRATOR_RESOURCE_ID_FIELD]: {
    title: _constants.fieldLabels.ORCHESTRATOR_RESOURCE_ID_LABEL
  },
  // Cloud
  [_discoverUtils.fieldConstants.CLOUD_PROVIDER_FIELD]: {
    title: _constants.fieldLabels.CLOUD_PROVIDER_LABEL
  },
  [_discoverUtils.fieldConstants.CLOUD_REGION_FIELD]: {
    title: _constants.fieldLabels.CLOUD_REGION_LABEL
  },
  [_discoverUtils.fieldConstants.CLOUD_AVAILABILITY_ZONE_FIELD]: {
    title: _constants.fieldLabels.CLOUD_AVAILABILITY_ZONE_LABEL
  },
  [_discoverUtils.fieldConstants.CLOUD_PROJECT_ID_FIELD]: {
    title: _constants.fieldLabels.CLOUD_PROJECT_ID_LABEL
  },
  [_discoverUtils.fieldConstants.CLOUD_INSTANCE_ID_FIELD]: {
    title: _constants.fieldLabels.CLOUD_INSTANCE_ID_LABEL
  },
  // Other
  [_discoverUtils.fieldConstants.LOG_FILE_PATH_FIELD]: {
    title: _constants.fieldLabels.LOG_FILE_PATH_LABEL
  },
  [_discoverUtils.fieldConstants.DATASTREAM_DATASET_FIELD]: {
    title: _constants.fieldLabels.DATASTREAM_DATASET_LABEL
  },
  [_discoverUtils.fieldConstants.DATASTREAM_NAMESPACE_FIELD]: {
    title: _constants.fieldLabels.DATASTREAM_NAMESPACE_LABEL,
    formatter: (value, formattedValue) => /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
      value: value,
      formattedValue: formattedValue,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 7
      }
    }, ({
      content
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 27
      }
    }, content))
  },
  [_discoverUtils.fieldConstants.AGENT_NAME_FIELD]: {
    title: _constants.fieldLabels.AGENT_NAME_LABEL
  }
};