"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogsOverviewHeader = LogsOverviewHeader;
exports.contentLabel = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _discoverUtils = require("@kbn/discover-utils");
var _i18n = require("@kbn/i18n");
var _ = require("../..");
var _timestamp = require("./sub_components/timestamp");
var _hover_popover_action = require("./sub_components/hover_popover_action");
var _log_level = require("./sub_components/log_level");
var _logs_overview_highlights = require("./logs_overview_highlights");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_doc_viewer/public/components/doc_viewer_logs_overview/logs_overview_header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const contentLabel = exports.contentLabel = _i18n.i18n.translate('unifiedDocViewer.docView.logsOverview.label.content', {
  defaultMessage: 'Content breakdown'
});
function LogsOverviewHeader({
  hit,
  formattedDoc,
  dataView,
  filter,
  onAddColumn,
  onRemoveColumn,
  renderFlyoutStreamProcessingLink
}) {
  const hasLogLevel = Boolean(formattedDoc[_discoverUtils.fieldConstants.LOG_LEVEL_FIELD]);
  const hasTimestamp = Boolean(formattedDoc[_discoverUtils.fieldConstants.TIMESTAMP_FIELD]);
  const {
    field,
    value,
    formattedValue
  } = (0, _discoverUtils.getMessageFieldWithFallbacks)(formattedDoc, {
    includeFormattedValue: true
  });
  const rawFieldValue = hit && field ? hit.flattened[field] : undefined;
  const messageCodeBlockProps = formattedValue ? {
    language: 'json',
    children: formattedValue
  } : {
    language: 'txt',
    dangerouslySetInnerHTML: {
      __html: value !== null && value !== void 0 ? value : ''
    }
  };
  const hasMessageField = field && value;
  const hasBadges = hasTimestamp || hasLogLevel || hasMessageField;
  const hasFlyoutHeader = hasMessageField || hasBadges;
  const accordionId = (0, _eui.useGeneratedHtmlId)({
    prefix: contentLabel
  });
  const badges = hasBadges && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "m",
    alignItems: "center",
    wrap: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  }, hasMessageField && renderFlyoutStreamProcessingLink && renderFlyoutStreamProcessingLink({
    doc: hit
  }), formattedDoc[_discoverUtils.fieldConstants.LOG_LEVEL_FIELD] && /*#__PURE__*/_react.default.createElement(_hover_popover_action.HoverActionPopover, {
    value: formattedDoc[_discoverUtils.fieldConstants.LOG_LEVEL_FIELD],
    field: _discoverUtils.fieldConstants.LOG_LEVEL_FIELD,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_log_level.LogLevel, {
    level: formattedDoc[_discoverUtils.fieldConstants.LOG_LEVEL_FIELD],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 11
    }
  })), hasTimestamp && /*#__PURE__*/_react.default.createElement(_timestamp.Timestamp, {
    timestamp: formattedDoc[_discoverUtils.fieldConstants.TIMESTAMP_FIELD],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 24
    }
  }));
  const contentField = hasMessageField && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    "data-test-subj": "unifiedDocViewLogsOverviewMessage",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexEnd",
    gutterSize: "none",
    justifyContent: "spaceBetween",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  }, field), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 9
    }
  }, badges)), /*#__PURE__*/_react.default.createElement(_hover_popover_action.HoverActionPopover, {
    value: value,
    formattedValue: formattedValue,
    field: field,
    rawFieldValue: rawFieldValue,
    anchorPosition: "downCenter",
    display: "block",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, (0, _extends2.default)({
    overflowHeight: 100,
    paddingSize: "s",
    isCopyable: true,
    fontSize: "s"
  }, messageCodeBlockProps, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 9
    }
  }))));
  return /*#__PURE__*/_react.default.createElement(_.ContentFrameworkSection, {
    id: accordionId,
    title: contentLabel,
    "data-test-subj": "unifiedDocViewLogsOverviewHeader",
    hasBorder: false,
    hasPadding: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 5
    }
  }, hasFlyoutHeader ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false,
    paddingSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 11
    }
  }, hasMessageField ? contentField : badges), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 11
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_logs_overview_highlights.LogsOverviewHighlights, {
    formattedDoc: formattedDoc,
    hit: hit,
    dataView: dataView,
    filter: filter,
    onAddColumn: onAddColumn,
    onRemoveColumn: onRemoveColumn,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 7
    }
  }));
}