"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.datasetQualityLinkTitle = exports.LogsOverviewDegradedFields = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _routerUtils = require("@kbn/router-utils");
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _esQuery = require("@kbn/es-query");
var _plugin = require("../../plugin");
var _scrollable_section_wrapper = require("./scrollable_section_wrapper");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_doc_viewer/public/components/doc_viewer_logs_overview/logs_overview_degraded_fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_SORT_FIELD = 'issue';
const DEFAULT_SORT_DIRECTION = 'asc';
const DEFAULT_ROWS_PER_PAGE = 5;
const DEFAULT_TABLE_OPTIONS = {
  page: {
    index: 0,
    size: 0
  },
  sort: {
    field: DEFAULT_SORT_FIELD,
    direction: DEFAULT_SORT_DIRECTION
  }
};
const qualityIssuesAccordionTitle = _i18n.i18n.translate('unifiedDocViewer.docView.logsOverview.accordion.title.qualityIssues', {
  defaultMessage: 'Quality Issues'
});
const qualityIssuesAccordionTechPreviewBadge = _i18n.i18n.translate('unifiedDocViewer.docView.logsOverview.accordion.title.techPreview', {
  defaultMessage: 'TECH PREVIEW'
});
const issueColumnName = _i18n.i18n.translate('unifiedDocViewer.docView.logsOverview.accordion.qualityIssues.table.field', {
  defaultMessage: 'Issue'
});
const valuesColumnName = _i18n.i18n.translate('unifiedDocViewer.docView.logsOverview.accordion.qualityIssues.table.values', {
  defaultMessage: 'Values'
});
const textFieldIgnored = _i18n.i18n.translate('unifiedDocViewer.docView.logsOverview.accordion.qualityIssues.table.textIgnored', {
  defaultMessage: 'field ignored'
});
const datasetQualityLinkTitle = exports.datasetQualityLinkTitle = _i18n.i18n.translate('unifiedDocViewer.docView.logsOverview.accordion.qualityIssues.table.datasetQualityLinkTitle', {
  defaultMessage: 'Data set details'
});
const LogsOverviewDegradedFields = exports.LogsOverviewDegradedFields = /*#__PURE__*/(0, _react.forwardRef)(({
  rawDoc
}, ref) => {
  var _Object$keys, _rawDoc$_index;
  const {
    ignored_field_values: ignoredFieldValues = {},
    fields: sourceFields = {}
  } = rawDoc;
  const countOfDegradedFields = (_Object$keys = Object.keys(ignoredFieldValues)) === null || _Object$keys === void 0 ? void 0 : _Object$keys.length;
  const columns = getDegradedFieldsColumns();
  const tableData = getDataFormattedForTable(ignoredFieldValues);
  const dataStream = getDataStreamRawName(sourceFields);
  const accordionId = (0, _eui.useGeneratedHtmlId)({
    prefix: qualityIssuesAccordionTitle
  });
  const isCCSRemoteIndex = (0, _esQuery.isCCSRemoteIndexName)((_rawDoc$_index = rawDoc._index) !== null && _rawDoc$_index !== void 0 ? _rawDoc$_index : '');
  const [tableOptions, setTableOptions] = (0, _react.useState)(DEFAULT_TABLE_OPTIONS);
  const onTableChange = options => {
    var _options$sort$field, _options$sort, _options$sort$directi, _options$sort2;
    setTableOptions({
      page: {
        index: options.page.index,
        size: options.page.size
      },
      sort: {
        field: (_options$sort$field = (_options$sort = options.sort) === null || _options$sort === void 0 ? void 0 : _options$sort.field) !== null && _options$sort$field !== void 0 ? _options$sort$field : DEFAULT_SORT_FIELD,
        direction: (_options$sort$directi = (_options$sort2 = options.sort) === null || _options$sort2 === void 0 ? void 0 : _options$sort2.direction) !== null && _options$sort$directi !== void 0 ? _options$sort$directi : DEFAULT_SORT_DIRECTION
      }
    });
  };
  const pagination = (0, _react.useMemo)(() => {
    var _tableData$length;
    return {
      pageIndex: tableOptions.page.index,
      pageSize: DEFAULT_ROWS_PER_PAGE,
      totalItemCount: (_tableData$length = tableData === null || tableData === void 0 ? void 0 : tableData.length) !== null && _tableData$length !== void 0 ? _tableData$length : 0,
      hidePerPageOptions: true
    };
  }, [tableData, tableOptions]);
  const renderedItems = (0, _react.useMemo)(() => {
    const sortedItems = (0, _lodash.orderBy)(tableData, tableOptions.sort.field, tableOptions.sort.direction);
    return sortedItems.slice(tableOptions.page.index * DEFAULT_ROWS_PER_PAGE, (tableOptions.page.index + 1) * DEFAULT_ROWS_PER_PAGE);
  }, [tableData, tableOptions]);
  const {
    share
  } = (0, _plugin.getUnifiedDocViewerServices)();
  const {
    url: urlService
  } = share;
  const accordionTitle = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    direction: "row",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 11
    }
  }, qualityIssuesAccordionTitle))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "default",
    "data-test-subj": "unifiedDocViewLogsOverviewDegradedFieldTitleCount",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 9
    }
  }, countOfDegradedFields)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    label: qualityIssuesAccordionTechPreviewBadge,
    color: "hollow",
    "data-test-subj": "unifiedDocViewLogsOverviewDegradedFieldsTechPreview",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 9
    }
  })));
  const [isAccordionExpanded, setIsAccordionExpanded] = (0, _react.useState)(false);
  return countOfDegradedFields > 0 ? /*#__PURE__*/_react.default.createElement(_scrollable_section_wrapper.ScrollableSectionWrapper, {
    ref: ref,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 5
    }
  }, ({
    forceState,
    onToggle
  }) => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
      id: accordionId,
      buttonContent: accordionTitle,
      forceState: forceState,
      onToggle: isOpen => {
        setIsAccordionExpanded(isOpen);
        if (onToggle) {
          onToggle(isOpen);
        }
      },
      extraAction: !isCCSRemoteIndex && /*#__PURE__*/_react.default.createElement(DatasetQualityLink, {
        urlService: urlService,
        dataStream: dataStream,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 216,
          columnNumber: 19
        }
      }),
      "data-test-subj": "unifiedDocViewLogsOverviewDegradedFieldsAccordion",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 204,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasBorder: true,
      hasShadow: false,
      paddingSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 221,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
      tableLayout: "fixed",
      columns: columns,
      items: renderedItems !== null && renderedItems !== void 0 ? renderedItems : [],
      sorting: {
        sort: tableOptions.sort
      },
      onChange: onTableChange,
      pagination: pagination,
      "data-test-subj": "unifiedDocViewLogsOverviewDegradedFieldsQualityIssuesTable",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 222,
        columnNumber: 17
      }
    }))), !isAccordionExpanded ? /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 233,
        columnNumber: 37
      }
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 233,
        columnNumber: 73
      }
    }));
  }) : null;
});
const getDegradedFieldsColumns = () => [{
  name: issueColumnName,
  sortable: true,
  field: 'issue',
  render: issue => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 248,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("b", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 249,
        columnNumber: 11
      }
    }, issue), "\xA0", textFieldIgnored);
  }
}, {
  name: valuesColumnName,
  sortable: true,
  field: 'values',
  render: values => {
    return values.map((value, idx) => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      key: idx,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 259,
        columnNumber: 41
      }
    }, JSON.stringify(value)));
  }
}];
const getDataFormattedForTable = ignoredFieldValues => {
  return Object.entries(ignoredFieldValues).map(([field, values]) => ({
    issue: field,
    values
  }));
};
const getDataStreamRawName = sourceFields => {
  if (sourceFields) {
    const dataStreamTypeArr = sourceFields['data_stream.type'];
    const dataStreamType = dataStreamTypeArr ? dataStreamTypeArr[0] : undefined;
    const dataStreamNameArr = sourceFields['data_stream.dataset'];
    const dataStreamName = dataStreamNameArr ? dataStreamNameArr[0] : undefined;
    const dataStreamNamespaceArr = sourceFields['data_stream.namespace'];
    const dataStreamNamespace = dataStreamNamespaceArr ? dataStreamNamespaceArr[0] : undefined;
    let dataStream;
    if (dataStreamType && dataStreamName && dataStreamNamespace) {
      dataStream = `${dataStreamType}-${dataStreamName}-${dataStreamNamespace}`;
    }
    return dataStream;
  }
};
const DatasetQualityLink = /*#__PURE__*/_react.default.memo(({
  urlService,
  dataStream
}) => {
  const locator = urlService.locators.get(_deeplinksObservability.DATA_QUALITY_DETAILS_LOCATOR_ID);
  if (!locator || !dataStream) return null;
  const datasetQualityUrl = locator === null || locator === void 0 ? void 0 : locator.getRedirectUrl({
    dataStream
  });
  const navigateToDatasetQuality = () => {
    locator === null || locator === void 0 ? void 0 : locator.navigate({
      dataStream
    });
  };
  const datasetQualityLinkProps = (0, _routerUtils.getRouterLinkProps)({
    href: datasetQualityUrl,
    onClick: navigateToDatasetQuality
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, (0, _extends2.default)({}, datasetQualityLinkProps, {
    color: "primary",
    "data-test-subj": "unifiedDocViewLogsOverviewDegradedFieldDatasetLink",
    iconType: "popout",
    target: "_blank",
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 319,
      columnNumber: 7
    }
  }), datasetQualityLinkTitle);
});