"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogsOverview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _discoverUtils = require("@kbn/discover-utils");
var _src = require("@kbn/discover-utils/src");
var _react2 = require("@emotion/react");
var _logs_overview_header = require("./logs_overview_header");
var _use_field_actions = require("../../hooks/use_field_actions");
var _plugin = require("../../plugin");
var _logs_overview_degraded_fields = require("./logs_overview_degraded_fields");
var _logs_overview_stacktrace_section = require("./logs_overview_stacktrace_section");
var _get_height = require("../doc_viewer_source/get_height");
var _trace_waterfall = require("../observability/traces/components/trace_waterfall");
var _use_data_sources = require("../observability/traces/hooks/use_data_sources");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_doc_viewer/public/components/doc_viewer_logs_overview/logs_overview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LogsOverview = exports.LogsOverview = /*#__PURE__*/(0, _react.forwardRef)(({
  columns,
  dataView,
  hit,
  decreaseAvailableHeightBy = _get_height.DEFAULT_MARGIN_BOTTOM,
  filter,
  onAddColumn,
  onRemoveColumn,
  renderAIAssistant,
  renderFlyoutStreamField,
  renderFlyoutStreamProcessingLink,
  indexes,
  showTraceWaterfall = true
}, ref) => {
  const {
    fieldFormats
  } = (0, _plugin.getUnifiedDocViewerServices)();
  const parsedDoc = (0, _discoverUtils.getLogDocumentOverview)(hit, {
    dataView,
    fieldFormats
  });
  const LogsOverviewAIAssistant = renderAIAssistant;
  const stacktraceFields = (0, _src.getStacktraceFields)(hit);
  const isStacktraceAvailable = Object.values(stacktraceFields).some(Boolean);
  const qualityIssuesSectionRef = (0, _react.useRef)(null);
  const stackTraceSectionRef = (0, _react.useRef)(null);
  const [containerRef, setContainerRef] = (0, _react.useState)(null);
  const containerHeight = containerRef ? (0, _get_height.getTabContentAvailableHeight)(containerRef, decreaseAvailableHeightBy) : 0;
  (0, _react.useImperativeHandle)(ref, () => ({
    openAndScrollToSection: section => {
      if (section === 'quality_issues') {
        var _qualityIssuesSection;
        (_qualityIssuesSection = qualityIssuesSectionRef.current) === null || _qualityIssuesSection === void 0 ? void 0 : _qualityIssuesSection.openAndScrollToSection();
      } else if (section === 'stacktrace') {
        var _stackTraceSectionRef;
        (_stackTraceSectionRef = stackTraceSectionRef.current) === null || _stackTraceSectionRef === void 0 ? void 0 : _stackTraceSectionRef.openAndScrollToSection();
      }
    }
  }), []);
  return /*#__PURE__*/_react.default.createElement(_use_field_actions.FieldActionsProvider, {
    columns: columns,
    filter: filter,
    onAddColumn: onAddColumn,
    onRemoveColumn: onRemoveColumn,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    ref: setContainerRef,
    css: containerHeight ? (0, _react2.css)`
                  height: ${containerHeight}px;
                  overflow: auto;
                ` : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_logs_overview_header.LogsOverviewHeader, {
    formattedDoc: parsedDoc,
    hit: hit,
    renderFlyoutStreamProcessingLink: renderFlyoutStreamProcessingLink,
    filter: filter,
    onAddColumn: onAddColumn,
    onRemoveColumn: onRemoveColumn,
    dataView: dataView,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 11
    }
  }, renderFlyoutStreamField && renderFlyoutStreamField({
    doc: hit
  })), /*#__PURE__*/_react.default.createElement(_logs_overview_degraded_fields.LogsOverviewDegradedFields, {
    ref: qualityIssuesSectionRef,
    rawDoc: hit.raw,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 11
    }
  }), isStacktraceAvailable && /*#__PURE__*/_react.default.createElement(_logs_overview_stacktrace_section.LogsOverviewStacktraceSection, {
    ref: stackTraceSectionRef,
    hit: hit,
    dataView: dataView,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 13
    }
  }), parsedDoc[_discoverUtils.TRACE_ID_FIELD] && showTraceWaterfall ? /*#__PURE__*/_react.default.createElement(_use_data_sources.DataSourcesProvider, {
    indexes: indexes,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_trace_waterfall.TraceWaterfall, {
    traceId: parsedDoc[_discoverUtils.TRACE_ID_FIELD],
    docId: parsedDoc[_discoverUtils.TRANSACTION_ID_FIELD] || parsedDoc[_discoverUtils.SPAN_ID_FIELD],
    serviceName: parsedDoc[_discoverUtils.SERVICE_NAME_FIELD],
    dataView: dataView,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 15
    }
  })) : null, LogsOverviewAIAssistant && /*#__PURE__*/_react.default.createElement(LogsOverviewAIAssistant, {
    doc: hit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 39
    }
  })));
});