"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContentFrameworkSection = ContentFrameworkSection;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _section_actions = require("./section_actions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/unified_doc_viewer/public/components/content_framework/section/section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ContentFrameworkSection({
  id,
  title,
  description,
  actions,
  children,
  onToggle,
  forceState = 'open',
  'data-test-subj': accordionDataTestSubj,
  isTechPreview = false,
  hasBorder = true,
  hasPadding = true
}) {
  const [accordionState, setAccordionState] = (0, _react.useState)(forceState);
  (0, _react.useEffect)(() => {
    setAccordionState(forceState);
  }, [forceState]);
  const handleToggle = isOpen => {
    setAccordionState(isOpen ? 'open' : 'closed');
    onToggle === null || onToggle === void 0 ? void 0 : onToggle(isOpen);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    "data-test-subj": accordionDataTestSubj,
    id: `sectionAccordion-${id}`,
    initialIsOpen: forceState === 'open',
    onToggle: handleToggle,
    forceState: accordionState,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 17
      }
    }, title))), description ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 15
      }
    }, isTechPreview ? /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
      size: "s",
      label: description,
      alignment: "middle",
      color: "hollow",
      iconType: "beaker",
      title: title,
      "data-test-subj": "ContentFrameworkSectionEuiBetaBadge",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 19
      }
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: description,
      size: "s",
      color: "subdued",
      "aria-label": description,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 19
      }
    })) : null),
    extraAction: (actions === null || actions === void 0 ? void 0 : actions.length) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      alignItems: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_section_actions.SectionActions, {
      actions: actions,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 17
      }
    }))),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: hasBorder,
    hasShadow: false,
    paddingSize: hasPadding ? 's' : 'none',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 9
    }
  }, children)), accordionState === 'closed' ? /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 38
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 74
    }
  }));
}