"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UiActionsService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _std = require("@kbn/std");
var _actions2 = require("../actions");
var _trigger_internal = require("../triggers/trigger_internal");
var _ui_actions_execution_service = require("./ui_actions_execution_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class UiActionsService {
  constructor({
    triggers: _triggers = new Map(),
    actions: _actions = new Map(),
    triggerToActions: _triggerToActions = new Map()
  } = {}) {
    (0, _defineProperty2.default)(this, "executionService", new _ui_actions_execution_service.UiActionsExecutionService());
    (0, _defineProperty2.default)(this, "triggers", void 0);
    (0, _defineProperty2.default)(this, "actions", void 0);
    (0, _defineProperty2.default)(this, "triggerToActions", void 0);
    (0, _defineProperty2.default)(this, "registerTrigger", trigger => {
      if (this.triggers.has(trigger.id)) {
        throw new Error(`Trigger [trigger.id = ${trigger.id}] already registered.`);
      }
      const triggerInternal = new _trigger_internal.TriggerInternal(this, trigger);
      this.triggers.set(trigger.id, triggerInternal);
      this.triggerToActions.set(trigger.id, []);
    });
    (0, _defineProperty2.default)(this, "hasTrigger", triggerId => {
      return Boolean(this.triggers.get(triggerId));
    });
    (0, _defineProperty2.default)(this, "getTrigger", triggerId => {
      const trigger = this.triggers.get(triggerId);
      if (!trigger) {
        throw new Error(`Trigger [triggerId = ${triggerId}] does not exist.`);
      }
      return trigger.contract;
    });
    /**
     * @deprecated
     *
     * Use `plugins.uiActions.registerActionAsync` instead.
     */
    (0, _defineProperty2.default)(this, "registerAction", definition => {
      if (this.actions.has(definition.id)) {
        throw new Error(`Action [action.id = ${definition.id}] already registered.`);
      }
      const action = new _actions2.ActionInternal(definition);
      this.actions.set(action.id, async () => action);
      return action;
    });
    (0, _defineProperty2.default)(this, "registerActionAsync", (id, getDefinition) => {
      if (this.actions.has(id)) {
        throw new Error(`Action [action.id = ${id}] already registered.`);
      }
      this.actions.set(id, async () => {
        const action = new _actions2.ActionInternal(await getDefinition());
        return action;
      });
    });
    (0, _defineProperty2.default)(this, "unregisterAction", actionId => {
      if (!this.actions.has(actionId)) {
        throw new Error(`Action [action.id = ${actionId}] is not registered.`);
      }
      this.actions.delete(actionId);
    });
    (0, _defineProperty2.default)(this, "hasAction", actionId => {
      return this.actions.has(actionId);
    });
    (0, _defineProperty2.default)(this, "attachAction", (triggerId, actionId) => {
      const trigger = this.triggers.get(triggerId);
      if (!trigger) {
        throw new Error(`No trigger [triggerId = ${triggerId}] exists, for attaching action [actionId = ${actionId}].`);
      }
      const actionIds = this.triggerToActions.get(triggerId);
      if (!actionIds.find(id => id === actionId)) {
        this.triggerToActions.set(triggerId, [...actionIds, actionId]);
      }
    });
    (0, _defineProperty2.default)(this, "detachAction", (triggerId, actionId) => {
      const trigger = this.triggers.get(triggerId);
      if (!trigger) {
        throw new Error(`No trigger [triggerId = ${triggerId}] exists, for detaching action [actionId = ${actionId}].`);
      }
      const actionIds = this.triggerToActions.get(triggerId);
      this.triggerToActions.set(triggerId, actionIds.filter(id => id !== actionId));
    });
    /**
     * @deprecated
     *
     * Use `plugins.uiActions.addTriggerActionAsync` instead.
     */
    (0, _defineProperty2.default)(this, "addTriggerAction", (triggerId, action) => {
      if (!this.actions.has(action.id)) this.registerAction(action);
      this.attachAction(triggerId, action.id);
    });
    /**
     * `addTriggerAction` is similar to `attachAction` as it attaches action to a
     * trigger, but it also registers the action, if it has not been registered, yet.
     */
    (0, _defineProperty2.default)(this, "addTriggerActionAsync", (triggerId, actionId, getDefinition) => {
      if (!this.actions.has(actionId)) this.registerActionAsync(actionId, getDefinition);
      this.attachAction(triggerId, actionId);
    });
    (0, _defineProperty2.default)(this, "getAction", async id => {
      const getAction = this.actions.get(id);
      if (!getAction) {
        throw new Error(`Action [action.id = ${id}] not registered.`);
      }
      return await getAction();
    });
    (0, _defineProperty2.default)(this, "getTriggerActions", async triggerId => {
      var _this$triggerToAction;
      // This line checks if trigger exists, otherwise throws.
      this.getTrigger(triggerId);
      const actionIds = (_this$triggerToAction = this.triggerToActions.get(triggerId)) !== null && _this$triggerToAction !== void 0 ? _this$triggerToAction : [];
      const actions = await (0, _std.asyncMap)(actionIds, async actionId => {
        var _this$actions$get;
        return await ((_this$actions$get = this.actions.get(actionId)) === null || _this$actions$get === void 0 ? void 0 : _this$actions$get());
      });
      return actions.filter(Boolean);
    });
    (0, _defineProperty2.default)(this, "getTriggerCompatibleActions", async (triggerId, context) => {
      const actions = await this.getTriggerActions(triggerId);
      const isCompatibles = await Promise.all(actions.map(action => action.isCompatible({
        ...context,
        trigger: this.getTrigger(triggerId)
      })));
      return actions.reduce((acc, action, i) => {
        if (isCompatibles[i]) {
          acc.push(action);
        }
        return acc;
      }, []);
    });
    (0, _defineProperty2.default)(this, "getFrequentlyChangingActionsForTrigger", async (triggerId, context) => {
      return (await this.getTriggerActions(triggerId)).filter(action => {
        var _action$couldBecomeCo;
        return Boolean(action.getCompatibilityChangesSubject) && ((_action$couldBecomeCo = action.couldBecomeCompatible) === null || _action$couldBecomeCo === void 0 ? void 0 : _action$couldBecomeCo.call(action, {
          ...context,
          trigger: this.getTrigger(triggerId)
        }));
      });
    });
    /**
     * @deprecated
     *
     * Use `plugins.uiActions.getTrigger(triggerId).exec(params)` instead.
     */
    (0, _defineProperty2.default)(this, "executeTriggerActions", async (triggerId, context) => {
      const trigger = this.getTrigger(triggerId);
      await trigger.exec(context);
    });
    /**
     * Removes all registered triggers and actions.
     */
    (0, _defineProperty2.default)(this, "clear", () => {
      this.actions.clear();
      this.triggers.clear();
      this.triggerToActions.clear();
    });
    /**
     * "Fork" a separate instance of `UiActionsService` that inherits all existing
     * triggers and actions, but going forward all new triggers and actions added
     * to this instance of `UiActionsService` are only available within this instance.
     */
    (0, _defineProperty2.default)(this, "fork", () => {
      const triggers = new Map();
      const actions = new Map();
      const triggerToActions = new Map();
      for (const [key, value] of this.triggers.entries()) triggers.set(key, value);
      for (const [key, value] of this.actions.entries()) actions.set(key, value);
      for (const [key, value] of this.triggerToActions.entries()) triggerToActions.set(key, [...value]);
      return new UiActionsService({
        triggers,
        actions,
        triggerToActions
      });
    });
    this.triggers = _triggers;
    this.actions = _actions;
    this.triggerToActions = _triggerToActions;
  }
}
exports.UiActionsService = UiActionsService;