"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildContextMenuForActions = buildContextMenuForActions;
exports.txtMore = exports.defaultTitle = void 0;
var React = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const defaultTitle = exports.defaultTitle = _i18n.i18n.translate('uiActions.actionPanel.title', {
  defaultMessage: 'Options'
});
const txtMore = exports.txtMore = _i18n.i18n.translate('uiActions.actionPanel.more', {
  defaultMessage: 'More'
});
const onClick = (action, context, close) => event => {
  if (event.currentTarget instanceof HTMLAnchorElement) {
    // from react-router's <Link/>
    if (!event.defaultPrevented &&
    // onClick prevented default
    event.button === 0 && (
    // ignore everything but left clicks
    !event.currentTarget.target || event.currentTarget.target === '_self') &&
    // let browser handle "target=_blank" etc.
    !(event.metaKey || event.altKey || event.ctrlKey || event.shiftKey) // ignore clicks with modifier keys
    ) {
      event.preventDefault();
      action.execute(context);
    }
  } else action.execute({
    ...context,
    event
  });
  close();
};

/**
 * This method adds "More" item to panels, which have more than 4 items; and
 * moves all items after the thrird one into that "More" sub-menu.
 */
const wrapMainPanelItemsIntoSubmenu = (panels, id) => {
  const panel = panels[id];
  if (!panel) return;
  const maxItemsBeforeWrapping = 4;
  if (!panel.items) return;
  if (panel.items.length <= maxItemsBeforeWrapping) return;
  const visibleItems = panel.items.slice(0, 3);
  const itemsInSubmenu = panel.items.slice(3);
  const morePanelId = panel.id + '__more';
  const more = {
    name: txtMore,
    panel: morePanelId,
    icon: 'boxesHorizontal',
    'data-test-subj': `embeddablePanelMore-${id}`,
    _order: -1
  };
  panel.items = [...visibleItems, more];
  const subPanel = {
    id: morePanelId,
    title: panel.title || defaultTitle,
    items: itemsInSubmenu
  };
  panels[morePanelId] = subPanel;
};
const removeItemMetaFields = items => {
  const euiItems = [];
  for (const item of items) {
    const {
      _order: omit,
      _title: omit2,
      ...rest
    } = item;
    euiItems.push(rest);
  }
  return euiItems;
};
const removePanelMetaFields = panels => {
  const euiPanels = [];
  for (const panel of panels) {
    const {
      _level: omit,
      _icon: omit2,
      _order: omit3,
      ...rest
    } = panel;
    euiPanels.push({
      ...rest,
      items: removeItemMetaFields(rest.items)
    });
  }
  return euiPanels;
};
/**
 * Transforms an array of Actions to the shape EuiContextMenuPanel expects.
 */
async function buildContextMenuForActions({
  actions,
  title = defaultTitle,
  closeMenu = () => {}
}) {
  const panels = {
    mainMenu: {
      id: 'mainMenu',
      items: []
    }
  };
  const promises = actions.map(async item => {
    const {
      action
    } = item;
    const context = {
      ...item.context,
      trigger: item.trigger
    };
    const isCompatible = await item.action.isCompatible(context);
    if (!isCompatible) return;
    let parentPanel = '';
    let currentPanel = '';
    if (action.grouping) {
      for (let i = 0; i < action.grouping.length; i++) {
        const group = action.grouping[i];
        currentPanel = group.id;
        if (!panels[currentPanel]) {
          const name = group.getDisplayName ? group.getDisplayName(context) : group.id;
          panels[currentPanel] = {
            id: currentPanel,
            title: name,
            items: [],
            _level: i,
            _order: group.order || 0,
            _icon: group.getIconType ? group.getIconType(context) : 'empty'
          };
          if (parentPanel) {
            panels[parentPanel].items.push({
              name,
              panel: currentPanel,
              icon: group.getIconType ? group.getIconType(context) : 'empty',
              _order: group.order || 0,
              _title: group.getDisplayName ? group.getDisplayName(context) : ''
            });
          }
        }
        parentPanel = currentPanel;
      }
    }
    panels[parentPanel || 'mainMenu'].items.push({
      name: action.MenuItem ? /*#__PURE__*/React.createElement(action.MenuItem, {
        context
      }) : action.getDisplayName(context),
      icon: action.getIconType(context),
      toolTipContent: action.getDisplayNameTooltip ? action.getDisplayNameTooltip(context) : '',
      'data-test-subj': `embeddablePanelAction-${action.id}`,
      onClick: onClick(action, context, closeMenu),
      href: action.getHref ? await action.getHref(context) : undefined,
      _order: action.order || 0,
      _title: action.getDisplayName(context),
      disabled: action.disabled
    });
  });
  await Promise.all(promises);
  for (const panel of Object.values(panels)) {
    const items = panel.items.filter(Boolean);
    panel.items = items.sort(({
      _order: orderA,
      _title: titleA
    }, {
      _order: orderB,
      _title: titleB
    }) => {
      const orderComparison = (orderB || 0) - (orderA || 0);
      if (orderComparison !== 0) return orderComparison;
      return (titleA || '').localeCompare(titleB || '');
    });
  }
  wrapMainPanelItemsIntoSubmenu(panels, 'mainMenu');
  const sortedPanels = Object.values(panels).sort((a, b) => {
    return (b._order || 0) - (a._order || 0);
  });
  for (const panel of sortedPanels) {
    if (panel._level === 0) {
      if (panels.mainMenu.items.length > 0) {
        panels.mainMenu.items.push({
          isSeparator: true,
          key: panel.id + '__separator'
        });
      }
      if (panel.items.length > 4) {
        panels.mainMenu.items.push({
          name: panel.title || panel.id,
          icon: panel._icon || 'empty',
          panel: panel.id
        });
      } else {
        panels.mainMenu.items.push(...panel.items);
      }
    }
  }
  const panelList = Object.values(panels);
  return removePanelMetaFields(panelList);
}