"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionFactoryView = void 0;
var _react = _interopRequireDefault(require("react"));
var _action_factory = require("../../components/action_factory");
var _context = require("../context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/ui_actions_enhanced/public/drilldowns/drilldown_manager/containers/action_factory_view/action_factory_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const ActionFactoryView = ({
  factory,
  context,
  constant
}) => {
  const drilldowns = (0, _context.useDrilldownManager)();
  const name = _react.default.useMemo(() => factory.getDisplayName(context), [factory, context]);
  const icon = _react.default.useMemo(() => factory.getIconType(context), [factory, context]);
  const handleChange = _react.default.useMemo(() => {
    if (constant) return undefined;
    return () => drilldowns.setActionFactory(undefined);
  }, [drilldowns, constant]);
  return /*#__PURE__*/_react.default.createElement(_action_factory.ActionFactory, {
    name: name,
    icon: icon,
    beta: factory.isBeta,
    onChange: handleChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 10
    }
  });
};
exports.ActionFactoryView = ActionFactoryView;