"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesListPrompts = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _empty_prompt = require("../../../components/prompts/empty_prompt");
var _center_justified_spinner = require("../../../components/center_justified_spinner");
var _no_permission_prompt = require("../../../components/prompts/no_permission_prompt");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/rules_list/components/rules_list_prompts.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const RulesListPrompts = props => {
  const {
    showNoAuthPrompt,
    showSpinner,
    showCreateRuleButtonInPrompt,
    showCreateFirstRulePrompt,
    onCreateRulesClick
  } = props;
  if (showNoAuthPrompt) return /*#__PURE__*/_react.default.createElement(_no_permission_prompt.NoPermissionPrompt, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 32
    }
  });
  if (showCreateFirstRulePrompt) {
    return /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, {
      showCreateRule: showCreateRuleButtonInPrompt,
      onCreateRulesClick: onCreateRulesClick,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 7
      }
    });
  }
  if (showSpinner) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
      grow: false,
      paddingSize: "none",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_center_justified_spinner.CenterJustifiedSpinner, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 9
      }
    }));
  }
  return null;
};
exports.RulesListPrompts = RulesListPrompts;