"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.RuleTagBadge = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/rules_list/components/rule_tag_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const tagTitle = _i18n.i18n.translate('xpack.triggersActionsUI.sections.rules_list.rules_tag_badge.tagTitle', {
  defaultMessage: 'Tag'
});
const containerStyle = {
  width: '300px'
};
const getTagItemDataTestSubj = tag => `ruleTagBadgeItem-${tag}`;
const RuleTagBadge = props => {
  const {
    tagsOutPopover = false,
    tags = [],
    badgeDataTestSubj = 'ruleTagBadge',
    titleDataTestSubj = 'ruleTagPopoverTitle',
    tagItemDataTestSubj = getTagItemDataTestSubj
  } = props;
  const {
    isOpen,
    onClose,
    onClick
  } = props;
  const badge = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      "data-test-subj": badgeDataTestSubj,
      color: "hollow",
      iconType: "tag",
      iconSide: "left",
      tabIndex: -1,
      onClick: onClick,
      onClickAriaLabel: "Tags",
      iconOnClick: onClick,
      iconOnClickAriaLabel: "Tags",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 7
      }
    }, tags.length);
  }, [badgeDataTestSubj, onClick, tags.length]);
  const tagBadges = (0, _react.useMemo)(() => tags.map((tag, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    "data-test-subj": tagItemDataTestSubj(tag),
    key: index,
    color: "hollow",
    iconType: "tag",
    iconSide: "left",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  }, tag)), [tags, tagItemDataTestSubj]);
  if (tagsOutPopover) {
    return (
      /*#__PURE__*/
      // Put 0 to fix negative left margin value.
      _react.default.createElement(_eui.EuiFlexGroup, {
        "data-test-subj": "tagsOutPopover",
        gutterSize: "s",
        style: {
          marginLeft: 0
        },
        wrap: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 93,
          columnNumber: 7
        }
      }, tagBadges)
    );
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: badge,
    anchorPosition: "upCenter",
    isOpen: isOpen // The props exists as it's required in props types
    ,
    closePopover: onClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    "data-test-subj": titleDataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 7
    }
  }, tagTitle), /*#__PURE__*/_react.default.createElement("div", {
    style: containerStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 7
    }
  }, tagBadges));
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.RuleTagBadge = RuleTagBadge;