"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePreviousSnoozeInterval = exports.scheduleSummary = exports.futureTimeToInterval = exports.durationToTextString = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _react = require("react");
var _parse_interval = require("../../../../../../../common/parse_interval");
var _helpers = require("../recurrence_scheduler/helpers");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PREV_SNOOZE_INTERVAL_KEY = 'triggersActionsUi_previousSnoozeInterval';
const usePreviousSnoozeInterval = propsInterval => {
  let intervalFromStorage = localStorage.getItem(PREV_SNOOZE_INTERVAL_KEY);
  if (intervalFromStorage) {
    try {
      (0, _parse_interval.parseInterval)(intervalFromStorage);
    } catch (e) {
      intervalFromStorage = null;
      localStorage.removeItem(PREV_SNOOZE_INTERVAL_KEY);
    }
  }
  const usePropsInterval = typeof propsInterval !== 'undefined';
  const interval = usePropsInterval ? propsInterval : intervalFromStorage;
  const [previousSnoozeInterval, setPreviousSnoozeInterval] = (0, _react.useState)(interval);
  const storeAndSetPreviousSnoozeInterval = newInterval => {
    if (!usePropsInterval) {
      localStorage.setItem(PREV_SNOOZE_INTERVAL_KEY, newInterval);
    }
    setPreviousSnoozeInterval(newInterval);
  };
  return [previousSnoozeInterval, storeAndSetPreviousSnoozeInterval];
};
exports.usePreviousSnoozeInterval = usePreviousSnoozeInterval;
const futureTimeToInterval = time => {
  if (!time) return;
  const relativeTime = (0, _moment.default)(time).locale('en').fromNow(true);
  const [valueStr, unitStr] = relativeTime.split(' ');
  let value = valueStr === 'a' || valueStr === 'an' ? 1 : parseInt(valueStr, 10);
  let unit;
  switch (unitStr) {
    case 'year':
    case 'years':
      unit = 'M';
      value = value * 12;
      break;
    case 'month':
    case 'months':
      unit = 'M';
      break;
    case 'day':
    case 'days':
      unit = 'd';
      break;
    case 'hour':
    case 'hours':
      unit = 'h';
      break;
    case 'minute':
    case 'minutes':
      unit = 'm';
      break;
  }
  if (!unit) return;
  return `${value}${unit}`;
};
exports.futureTimeToInterval = futureTimeToInterval;
const durationToTextString = (value, unit) => {
  // Moment.humanize will parse "1" as "a" or "an", e.g "an hour"
  // Override this to output "1 hour"
  if (value === 1) {
    return _translations.ONE[unit];
  }
  return _moment.default.duration(value, unit).humanize();
};
exports.durationToTextString = durationToTextString;
const scheduleSummary = schedule => {
  if (schedule.rRule.freq == null) return (0, _moment.default)(schedule.rRule.dtstart).format('LLLL');
  const summary = (0, _helpers.recurrenceSummary)(schedule.rRule);
  // Capitalize first letter of summary
  return summary[0].toLocaleUpperCase() + summary.slice(1);
};
exports.scheduleSummary = scheduleSummary;