"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NumberField = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/rules_list/components/rule_snooze/helpers/number_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NumberField = props => {
  const [displayValue, setDisplayValue] = (0, _react.useState)(props.value);
  const min = typeof props.min !== 'undefined' ? props.min : -Infinity;
  const max = typeof props.max !== 'undefined' ? props.max : Infinity;
  const onChange = (0, _react.useCallback)(e => {
    const {
      value
    } = e.target;
    const valueAsNumber = Number(value);
    const isValid = !isNaN(valueAsNumber) && valueAsNumber >= min && valueAsNumber <= max;
    if (isValid || value === '') {
      setDisplayValue(value);
    }
    if (isValid && props.onChange) {
      props.onChange(value);
    }
  }, [props, setDisplayValue, max, min]);
  const onBlur = (0, _react.useCallback)(e => {
    if (isNaN(Number(displayValue)) || displayValue === '') {
      setDisplayValue(props.value);
    }
    if (props.onBlur) props.onBlur(e);
  }, [displayValue, props, setDisplayValue]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, (0, _extends2.default)({}, props, {
    value: displayValue,
    onChange: onChange,
    onBlur: onBlur,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 10
    }
  }));
};
exports.NumberField = NumberField;